/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.LockTimeoutException;
import org.gradle.cache.internal.ProcessMetaDataProvider;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.util.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileLockManager
implements FileLockManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileLockManager.class);
    private static final int LOCK_TIMEOUT = 60000;
    private static final byte STATE_REGION_PROTOCOL = 1;
    private static final int STATE_REGION_SIZE = 2;
    private static final int STATE_REGION_POS = 0;
    private static final byte INFORMATION_REGION_PROTOCOL = 2;
    private static final int INFORMATION_REGION_POS = 2;
    private final Set<File> lockedFiles = new CopyOnWriteArraySet<File>();
    private final ProcessMetaDataProvider metaDataProvider;

    public DefaultFileLockManager(ProcessMetaDataProvider processMetaDataProvider) {
        this.metaDataProvider = processMetaDataProvider;
    }

    public FileLock lock(File file, FileLockManager.LockMode lockMode, String string) throws LockTimeoutException {
        return this.lock(file, lockMode, string, "");
    }

    public FileLock lock(File file, FileLockManager.LockMode lockMode, String string, String string2) {
        if (lockMode == FileLockManager.LockMode.None) {
            throw new UnsupportedOperationException(String.format("No %s mode lock implementation available.", new Object[]{lockMode}));
        }
        File file2 = GFileUtils.canonicalise(file);
        if (!this.lockedFiles.add(file2)) {
            throw new IllegalStateException(String.format("Cannot lock %s as it has already been locked by this process.", string));
        }
        try {
            return new DefaultFileLock(file2, lockMode, string, string2);
        }
        catch (Throwable throwable) {
            this.lockedFiles.remove(file2);
            throw UncheckedException.throwAsUncheckedException((Throwable)throwable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultFileLock
    extends AbstractFileAccess
    implements FileLock {
        private final File lockFile;
        private final File target;
        private final FileLockManager.LockMode mode;
        private final String displayName;
        private final String operationDisplayName;
        private java.nio.channels.FileLock lock;
        private RandomAccessFile lockFileAccess;

        public DefaultFileLock(File file, FileLockManager.LockMode lockMode, String string, String string2) throws Throwable {
            this.target = file;
            this.mode = lockMode;
            this.displayName = string;
            this.operationDisplayName = string2;
            this.lockFile = file.isDirectory() ? new File(file, file.getName() + ".lock") : new File(file.getParentFile(), file.getName() + ".lock");
            this.lockFile.getParentFile().mkdirs();
            this.lockFile.createNewFile();
            this.lockFileAccess = new RandomAccessFile(this.lockFile, "rw");
            try {
                this.lock = this.lock(lockMode);
            }
            catch (Throwable throwable) {
                this.lockFileAccess.close();
                throw throwable;
            }
        }

        @Override
        public boolean isLockFile(File file) {
            return file.equals(this.lockFile);
        }

        @Override
        public boolean getUnlockedCleanly() {
            return ((AbstractFileAccess)this).readFromFile(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try {
                        DefaultFileLock.this.lockFileAccess.seek(1L);
                        if (!DefaultFileLock.this.lockFileAccess.readBoolean()) {
                            return false;
                        }
                    }
                    catch (EOFException eOFException) {
                        return false;
                    }
                    return true;
                }
            });
        }

        @Override
        public <T> T readFromFile(Factory<? extends T> factory) throws LockTimeoutException {
            this.assertOpen();
            return (T)factory.create();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeToFile(Runnable runnable) {
            this.assertOpen();
            try {
                java.nio.channels.FileLock fileLock = null;
                if (this.mode != FileLockManager.LockMode.Exclusive) {
                    this.lock.release();
                    this.lock = null;
                    fileLock = this.lock(FileLockManager.LockMode.Exclusive);
                }
                try {
                    this.markDirty();
                    runnable.run();
                    this.markClean();
                }
                finally {
                    if (this.mode != FileLockManager.LockMode.Exclusive) {
                        fileLock.release();
                        this.lock = this.lock(this.mode);
                    }
                }
            }
            catch (Throwable throwable) {
                throw UncheckedException.throwAsUncheckedException((Throwable)throwable);
            }
        }

        private void assertOpen() {
            if (this.lock == null) {
                throw new IllegalStateException("This lock has been closed.");
            }
        }

        private void markClean() throws IOException {
            this.lockFileAccess.seek(0L);
            this.lockFileAccess.writeByte(1);
            this.lockFileAccess.writeBoolean(true);
            assert (this.lockFileAccess.getFilePointer() == 2L);
        }

        private void markDirty() throws IOException {
            this.lockFileAccess.seek(0L);
            this.lockFileAccess.writeByte(1);
            this.lockFileAccess.writeBoolean(false);
            assert (this.lockFileAccess.getFilePointer() == 2L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.lockFileAccess == null) {
                return;
            }
            try {
                LOGGER.debug("Releasing lock on {}.", (Object)this.displayName);
                DefaultFileLockManager.this.lockedFiles.remove(this.target);
                try {
                    if (this.lock != null && !this.lock.isShared()) {
                        this.lockFileAccess.setLength(2L);
                    }
                }
                finally {
                    this.lockFileAccess.close();
                }
            }
            catch (IOException iOException) {
                LOGGER.warn("Error releasing lock on {}: {}", (Object)this.displayName, (Object)iOException);
            }
            finally {
                this.lock = null;
                this.lockFileAccess = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private java.nio.channels.FileLock lock(FileLockManager.LockMode lockMode) throws Throwable {
            java.nio.channels.FileLock fileLock;
            block19: {
                LOGGER.debug("Waiting to acquire {} lock on {}.", (Object)lockMode.toString().toLowerCase(), (Object)this.displayName);
                long l = System.currentTimeMillis() + 60000L;
                fileLock = this.lockStateRegion(lockMode, l);
                if (fileLock == null) {
                    String string = "unknown";
                    String string2 = "unknown";
                    java.nio.channels.FileLock fileLock2 = this.lockInformationRegion(FileLockManager.LockMode.Shared, l);
                    if (fileLock2 == null) {
                        LOGGER.debug("Could not lock information region for {}. Ignoring.", (Object)this.displayName);
                    } else {
                        try {
                            if (this.lockFileAccess.length() < 2L) {
                                LOGGER.debug("Lock file for {} is too short to contain information region. Ignoring.", (Object)this.displayName);
                            } else {
                                this.lockFileAccess.seek(2L);
                                if (this.lockFileAccess.readByte() != 2) {
                                    throw new IllegalStateException(String.format("Unexpected lock protocol found in lock file '%s' for %s.", this.lockFile, this.displayName));
                                }
                                string = this.lockFileAccess.readUTF();
                                string2 = this.lockFileAccess.readUTF();
                            }
                        }
                        finally {
                            fileLock2.release();
                        }
                    }
                    throw new LockTimeoutException(String.format("Timeout waiting to lock %s. It is currently in use by another Gradle instance.%nOwner PID: %s%nOur PID: %s%nOwner Operation: %s%nOur operation: %s%nLock file: %s", this.displayName, DefaultFileLockManager.this.metaDataProvider.getProcessIdentifier(), string, string2, this.operationDisplayName, this.lockFile));
                }
                try {
                    java.nio.channels.FileLock fileLock3;
                    if (this.lockFileAccess.length() > 0L) {
                        this.lockFileAccess.seek(0L);
                        if (this.lockFileAccess.readByte() != 1) {
                            throw new IllegalStateException(String.format("Unexpected lock protocol found in lock file '%s' for %s.", this.lockFile, this.displayName));
                        }
                    }
                    if (fileLock.isShared()) break block19;
                    if (this.lockFileAccess.length() < 2L) {
                        this.lockFileAccess.seek(0L);
                        this.lockFileAccess.writeByte(1);
                        this.lockFileAccess.writeBoolean(false);
                    }
                    if ((fileLock3 = this.lockInformationRegion(FileLockManager.LockMode.Exclusive, l)) == null) {
                        throw new IllegalStateException(String.format("Timeout waiting to lock the information region for lock %s", this.displayName));
                    }
                    try {
                        this.lockFileAccess.seek(2L);
                        this.lockFileAccess.writeByte(2);
                        this.lockFileAccess.writeUTF(DefaultFileLockManager.this.metaDataProvider.getProcessIdentifier());
                        this.lockFileAccess.writeUTF(this.operationDisplayName);
                        this.lockFileAccess.setLength(this.lockFileAccess.getFilePointer());
                    }
                    finally {
                        fileLock3.release();
                    }
                }
                catch (Throwable throwable) {
                    fileLock.release();
                    throw throwable;
                }
            }
            LOGGER.debug("Lock acquired.");
            return fileLock;
        }

        private java.nio.channels.FileLock lockStateRegion(FileLockManager.LockMode lockMode, long l) throws IOException, InterruptedException {
            return this.lockRegion(lockMode, l, 0L, 2L);
        }

        private java.nio.channels.FileLock lockInformationRegion(FileLockManager.LockMode lockMode, long l) throws IOException, InterruptedException {
            return this.lockRegion(lockMode, l, 2L, 0x7FFFFFFFFFFFFFFDL);
        }

        private java.nio.channels.FileLock lockRegion(FileLockManager.LockMode lockMode, long l, long l2, long l3) throws IOException, InterruptedException {
            do {
                java.nio.channels.FileLock fileLock;
                if ((fileLock = this.lockFileAccess.getChannel().tryLock(l2, l3, lockMode == FileLockManager.LockMode.Shared)) != null) {
                    return fileLock;
                }
                Thread.sleep(200L);
            } while (System.currentTimeMillis() < l);
            return null;
        }
    }
}

