/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gradle.CacheUsage;
import org.gradle.api.Action;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.DefaultSerializer;
import org.gradle.cache.DirectoryCacheBuilder;
import org.gradle.cache.ObjectCacheBuilder;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentStateCache;
import org.gradle.cache.Serializer;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheRepository
implements CacheRepository {
    private final GradleVersion version = GradleVersion.current();
    private final File globalCacheDir;
    private final CacheUsage cacheUsage;
    private final File projectCacheDir;
    private final CacheFactory factory;

    public DefaultCacheRepository(File file, File file2, CacheUsage cacheUsage, CacheFactory cacheFactory) {
        this.projectCacheDir = file2;
        this.factory = cacheFactory;
        this.globalCacheDir = new File(file, "caches");
        this.cacheUsage = cacheUsage;
    }

    @Override
    public DirectoryCacheBuilder store(String string) {
        return new PersistentStoreBuilder(string);
    }

    @Override
    public DirectoryCacheBuilder cache(String string) {
        return new PersistentCacheBuilder(string);
    }

    @Override
    public <E> ObjectCacheBuilder<E, PersistentStateCache<E>> stateCache(Class<E> clazz, String string) {
        return new StateCacheBuilder(string);
    }

    @Override
    public <K, V> ObjectCacheBuilder<V, PersistentIndexedCache<K, V>> indexedCache(Class<K> clazz, Class<V> clazz2, String string) {
        return new IndexedCacheBuilder(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexedCacheBuilder<K, V>
    extends AbstractObjectCacheBuilder<V, PersistentIndexedCache<K, V>> {
        private IndexedCacheBuilder(String string) {
            super(string);
        }

        @Override
        protected PersistentIndexedCache<K, V> doOpen(File file, Map<String, ?> map, CacheValidator cacheValidator) {
            return DefaultCacheRepository.this.factory.openIndexedCache(file, DefaultCacheRepository.this.cacheUsage, cacheValidator, map, FileLockManager.LockMode.Exclusive, this.serializer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StateCacheBuilder<E>
    extends AbstractObjectCacheBuilder<E, PersistentStateCache<E>> {
        protected StateCacheBuilder(String string) {
            super(string);
        }

        @Override
        protected PersistentStateCache<E> doOpen(File file, Map<String, ?> map, CacheValidator cacheValidator) {
            return DefaultCacheRepository.this.factory.openStateCache(file, DefaultCacheRepository.this.cacheUsage, cacheValidator, map, FileLockManager.LockMode.Exclusive, this.serializer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractObjectCacheBuilder<E, T>
    extends AbstractCacheBuilder<T>
    implements ObjectCacheBuilder<E, T> {
        protected Serializer<E> serializer;

        protected AbstractObjectCacheBuilder(String string) {
            super(string);
            this.serializer = new DefaultSerializer<E>();
        }

        @Override
        public ObjectCacheBuilder<E, T> forObject(Object object) {
            super.forObject(object);
            return this;
        }

        @Override
        public ObjectCacheBuilder<E, T> withProperties(Map<String, ?> map) {
            super.withProperties(map);
            return this;
        }

        @Override
        public ObjectCacheBuilder<E, T> withVersionStrategy(CacheBuilder.VersionStrategy versionStrategy) {
            super.withVersionStrategy(versionStrategy);
            return this;
        }

        @Override
        public ObjectCacheBuilder<E, T> withSerializer(Serializer<E> serializer) {
            this.serializer = serializer;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PersistentStoreBuilder
    extends PersistentCacheBuilder {
        private PersistentStoreBuilder(String string) {
            super(string);
        }

        @Override
        protected PersistentCache doOpen(File file, Map<String, ?> map, CacheValidator cacheValidator) {
            if (!map.isEmpty()) {
                throw new UnsupportedOperationException("Properties are not supported for stores.");
            }
            return DefaultCacheRepository.this.factory.openStore(file, this.displayName, this.lockMode, this.initializer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PersistentCacheBuilder
    extends AbstractCacheBuilder<PersistentCache>
    implements DirectoryCacheBuilder {
        Action<? super PersistentCache> initializer;
        FileLockManager.LockMode lockMode;
        String displayName;

        protected PersistentCacheBuilder(String string) {
            super(string);
            this.lockMode = FileLockManager.LockMode.Shared;
        }

        @Override
        public DirectoryCacheBuilder forObject(Object object) {
            super.forObject(object);
            return this;
        }

        @Override
        public DirectoryCacheBuilder withProperties(Map<String, ?> map) {
            super.withProperties(map);
            return this;
        }

        @Override
        public DirectoryCacheBuilder withVersionStrategy(CacheBuilder.VersionStrategy versionStrategy) {
            super.withVersionStrategy(versionStrategy);
            return this;
        }

        @Override
        public DirectoryCacheBuilder withValidator(CacheValidator cacheValidator) {
            super.withValidator(cacheValidator);
            return this;
        }

        @Override
        public DirectoryCacheBuilder withInitializer(Action<? super PersistentCache> action) {
            this.initializer = action;
            return this;
        }

        @Override
        public DirectoryCacheBuilder withDisplayName(String string) {
            this.displayName = string;
            return this;
        }

        @Override
        public DirectoryCacheBuilder withLockMode(FileLockManager.LockMode lockMode) {
            this.lockMode = lockMode;
            return this;
        }

        @Override
        protected PersistentCache doOpen(File file, Map<String, ?> map, CacheValidator cacheValidator) {
            return DefaultCacheRepository.this.factory.open(file, this.displayName, DefaultCacheRepository.this.cacheUsage, cacheValidator, map, this.lockMode, this.initializer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractCacheBuilder<T>
    implements CacheBuilder<T> {
        private final String key;
        private Map<String, ?> properties = Collections.emptyMap();
        private Object target;
        private CacheBuilder.VersionStrategy versionStrategy = CacheBuilder.VersionStrategy.CachePerVersion;
        private CacheValidator validator;

        protected AbstractCacheBuilder(String string) {
            this.key = string;
        }

        @Override
        public CacheBuilder<T> withProperties(Map<String, ?> map) {
            this.properties = map;
            return this;
        }

        @Override
        public CacheBuilder<T> withVersionStrategy(CacheBuilder.VersionStrategy versionStrategy) {
            this.versionStrategy = versionStrategy;
            return this;
        }

        @Override
        public CacheBuilder<T> forObject(Object object) {
            this.target = object;
            return this;
        }

        @Override
        public CacheBuilder<T> withValidator(CacheValidator cacheValidator) {
            this.validator = cacheValidator;
            return this;
        }

        @Override
        public T open() {
            File file;
            HashMap hashMap = new HashMap(this.properties);
            if (this.target == null) {
                file = DefaultCacheRepository.this.globalCacheDir;
            } else if (this.target instanceof Gradle) {
                Gradle gradle = (Gradle)this.target;
                File file2 = gradle.getRootProject().getProjectDir();
                file = this.maybeProjectCacheDir(file2);
            } else if (this.target instanceof File) {
                file = new File((File)this.target, ".gradle");
            } else {
                throw new IllegalArgumentException(String.format("Cannot create cache for unrecognised domain object %s.", this.target));
            }
            switch (this.versionStrategy) {
                case SharedCache: {
                    break;
                }
                case CachePerVersion: {
                    file = new File(file, DefaultCacheRepository.this.version.getVersion());
                    break;
                }
                case SharedCacheInvalidateOnVersionChange: {
                    file = new File(file, "noVersion");
                    hashMap.put("gradle.version", DefaultCacheRepository.this.version.getVersion());
                }
            }
            return this.doOpen(new File(file, this.key), hashMap, this.validator);
        }

        protected abstract T doOpen(File var1, Map<String, ?> var2, CacheValidator var3);

        private File maybeProjectCacheDir(File file) {
            if (DefaultCacheRepository.this.projectCacheDir != null) {
                return DefaultCacheRepository.this.projectCacheDir;
            }
            return new File(file, ".gradle");
        }
    }
}

