/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.CacheUsage;
import org.gradle.api.Action;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.DefaultSerializer;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentStateCache;
import org.gradle.cache.Serializer;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.cache.internal.DefaultPersistentDirectoryCache;
import org.gradle.cache.internal.DefaultPersistentDirectoryStore;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.MultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.SimpleStateCache;
import org.gradle.cache.internal.btree.BTreePersistentIndexedCache;
import org.gradle.internal.Factory;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheFactory
implements Factory<CacheFactory> {
    private final Map<File, DirCacheReference> dirCaches = new HashMap<File, DirCacheReference>();
    private final FileLockManager lockManager;

    public DefaultCacheFactory(FileLockManager fileLockManager) {
        this.lockManager = fileLockManager;
    }

    public CacheFactory create() {
        return new CacheFactoryImpl();
    }

    void onOpen(Object object) {
    }

    void onClose(Object object) {
    }

    public void close() {
        for (DirCacheReference dirCacheReference : this.dirCaches.values()) {
            dirCacheReference.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StateCacheReference<E>
    extends NestedCacheReference<SimpleStateCache<E>> {
        private StateCacheReference(SimpleStateCache<E> simpleStateCache, DirCacheReference dirCacheReference) {
            super(simpleStateCache, dirCacheReference);
        }

        @Override
        public void close() {
            this.backingCache.stateCache = null;
            super.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexedCacheReference<K, V>
    extends NestedCacheReference<MultiProcessSafePersistentIndexedCache<K, V>> {
        private IndexedCacheReference(MultiProcessSafePersistentIndexedCache<K, V> multiProcessSafePersistentIndexedCache, DirCacheReference dirCacheReference) {
            super(multiProcessSafePersistentIndexedCache, dirCacheReference);
        }

        @Override
        public void close() {
            this.backingCache.indexedCache = null;
            ((MultiProcessSafePersistentIndexedCache)this.getCache()).close();
            super.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class NestedCacheReference<T>
    extends BasicCacheReference<T> {
        protected final DirCacheReference backingCache;

        protected NestedCacheReference(T t, DirCacheReference dirCacheReference) {
            super(t);
            this.backingCache = dirCacheReference;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DirCacheReference
    extends BasicCacheReference<DefaultPersistentDirectoryStore> {
        private final Map<String, ?> properties;
        private final FileLockManager.LockMode lockMode;
        IndexedCacheReference indexedCache;
        StateCacheReference stateCache;
        CacheFactoryImpl rebuiltBy;

        public DirCacheReference(DefaultPersistentDirectoryStore defaultPersistentDirectoryStore, Map<String, ?> map, FileLockManager.LockMode lockMode) {
            super(defaultPersistentDirectoryStore);
            this.properties = map;
            this.lockMode = lockMode;
        }

        public <E> StateCacheReference<E> getStateCache(Serializer<E> serializer) {
            if (this.stateCache == null) {
                SimpleStateCache<E> simpleStateCache = new SimpleStateCache<E>(new File(((DefaultPersistentDirectoryStore)this.getCache()).getBaseDir(), "state.bin"), ((DefaultPersistentDirectoryStore)this.getCache()).getLock(), serializer);
                this.stateCache = new StateCacheReference(simpleStateCache, this);
            }
            return this.stateCache;
        }

        public <K, V> IndexedCacheReference<K, V> getIndexedCache(Serializer<V> serializer) {
            if (this.indexedCache == null) {
                final BTreePersistentIndexedCache bTreePersistentIndexedCache = new BTreePersistentIndexedCache(new File(((DefaultPersistentDirectoryStore)this.getCache()).getBaseDir(), "cache.bin"), new DefaultSerializer(), serializer);
                Factory factory = new Factory<BTreePersistentIndexedCache<K, V>>(){

                    public BTreePersistentIndexedCache<K, V> create() {
                        return bTreePersistentIndexedCache;
                    }
                };
                MultiProcessSafePersistentIndexedCache multiProcessSafePersistentIndexedCache = new MultiProcessSafePersistentIndexedCache(factory, ((DefaultPersistentDirectoryStore)this.getCache()).getLock());
                this.indexedCache = new IndexedCacheReference(multiProcessSafePersistentIndexedCache, this);
            }
            return this.indexedCache;
        }

        @Override
        public void close() {
            DefaultCacheFactory.this.dirCaches.values().remove(this);
            ((DefaultPersistentDirectoryStore)this.getCache()).close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BasicCacheReference<T> {
        private Set<CacheFactoryImpl> references = new HashSet<CacheFactoryImpl>();
        private final T cache;

        protected BasicCacheReference(T t) {
            this.cache = t;
            DefaultCacheFactory.this.onOpen(t);
        }

        public T getCache() {
            return this.cache;
        }

        public void release(CacheFactoryImpl cacheFactoryImpl) {
            boolean bl = this.references.remove(cacheFactoryImpl);
            assert (bl);
            if (this.references.isEmpty()) {
                DefaultCacheFactory.this.onClose(this.cache);
                this.close();
            }
        }

        public void addReference(CacheFactoryImpl cacheFactoryImpl) {
            this.references.add(cacheFactoryImpl);
            cacheFactoryImpl.caches.add(this);
        }

        public void close() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CacheFactoryImpl
    implements CacheFactory {
        private final Set<BasicCacheReference<?>> caches = new LinkedHashSet();

        private CacheFactoryImpl() {
        }

        private DirCacheReference doOpenDir(File file, String string, CacheUsage cacheUsage, CacheValidator cacheValidator, Map<String, ?> map, FileLockManager.LockMode lockMode, Action<? super PersistentCache> action) {
            File file2 = GFileUtils.canonicalise(file);
            DirCacheReference dirCacheReference = (DirCacheReference)DefaultCacheFactory.this.dirCaches.get(file2);
            if (dirCacheReference == null) {
                DefaultPersistentDirectoryCache defaultPersistentDirectoryCache = new DefaultPersistentDirectoryCache(file2, string, cacheUsage, cacheValidator, map, lockMode, action, DefaultCacheFactory.this.lockManager);
                defaultPersistentDirectoryCache.open();
                dirCacheReference = new DirCacheReference(defaultPersistentDirectoryCache, map, lockMode);
                DefaultCacheFactory.this.dirCaches.put(file2, dirCacheReference);
            } else {
                if (cacheUsage == CacheUsage.REBUILD && dirCacheReference.rebuiltBy != this) {
                    throw new IllegalStateException(String.format("Cannot rebuild cache '%s' as it is already open.", file));
                }
                if (lockMode != dirCacheReference.lockMode) {
                    throw new IllegalStateException(String.format("Cannot open cache '%s' with %s lock mode as it is already open with %s lock mode.", file, lockMode.toString().toLowerCase(), dirCacheReference.lockMode.toString().toLowerCase()));
                }
                if (!map.equals(dirCacheReference.properties)) {
                    throw new IllegalStateException(String.format("Cache '%s' is already open with different state.", file));
                }
            }
            if (cacheUsage == CacheUsage.REBUILD) {
                dirCacheReference.rebuiltBy = this;
            }
            dirCacheReference.addReference(this);
            return dirCacheReference;
        }

        @Override
        public PersistentCache openStore(File file, String string, FileLockManager.LockMode lockMode, Action<? super PersistentCache> action) throws CacheOpenException {
            if (action != null) {
                throw new UnsupportedOperationException("Initializer actions are not currently supported by the directory store implementation.");
            }
            File file2 = GFileUtils.canonicalise(file);
            DirCacheReference dirCacheReference = (DirCacheReference)DefaultCacheFactory.this.dirCaches.get(file2);
            if (dirCacheReference == null) {
                DefaultPersistentDirectoryStore defaultPersistentDirectoryStore = new DefaultPersistentDirectoryStore(file2, string, lockMode, DefaultCacheFactory.this.lockManager);
                defaultPersistentDirectoryStore.open();
                dirCacheReference = new DirCacheReference(defaultPersistentDirectoryStore, Collections.emptyMap(), lockMode);
                DefaultCacheFactory.this.dirCaches.put(file2, dirCacheReference);
            }
            dirCacheReference.addReference(this);
            return (PersistentCache)dirCacheReference.getCache();
        }

        @Override
        public PersistentCache open(File file, String string, CacheUsage cacheUsage, CacheValidator cacheValidator, Map<String, ?> map, FileLockManager.LockMode lockMode, Action<? super PersistentCache> action) {
            DirCacheReference dirCacheReference = this.doOpenDir(file, string, cacheUsage, cacheValidator, map, lockMode, action);
            return (PersistentCache)dirCacheReference.getCache();
        }

        @Override
        public <E> PersistentStateCache<E> openStateCache(File file, CacheUsage cacheUsage, CacheValidator cacheValidator, Map<String, ?> map, FileLockManager.LockMode lockMode, Serializer<E> serializer) {
            StateCacheReference<E> stateCacheReference = this.doOpenDir(file, null, cacheUsage, cacheValidator, map, lockMode, null).getStateCache(serializer);
            stateCacheReference.addReference(this);
            return (PersistentStateCache)stateCacheReference.getCache();
        }

        @Override
        public <K, V> PersistentIndexedCache<K, V> openIndexedCache(File file, CacheUsage cacheUsage, CacheValidator cacheValidator, Map<String, ?> map, FileLockManager.LockMode lockMode, Serializer<V> serializer) {
            if (lockMode != FileLockManager.LockMode.Exclusive) {
                throw new UnsupportedOperationException(String.format("No %s mode indexed cache implementation is available.", new Object[]{lockMode}));
            }
            IndexedCacheReference indexedCacheReference = this.doOpenDir(file, null, cacheUsage, cacheValidator, map, FileLockManager.LockMode.Exclusive, null).getIndexedCache(serializer);
            indexedCacheReference.addReference(this);
            return (PersistentIndexedCache)indexedCacheReference.getCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                ArrayList arrayList = new ArrayList(this.caches);
                Collections.reverse(arrayList);
                for (BasicCacheReference basicCacheReference : arrayList) {
                    basicCacheReference.release(this);
                }
            }
            finally {
                this.caches.clear();
            }
        }
    }
}

