/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.gradle.cache.CacheAccess;
import org.gradle.cache.DefaultSerializer;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.Serializer;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.FileAccess;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.LockTimeoutException;
import org.gradle.cache.internal.MultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.btree.BTreePersistentIndexedCache;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DefaultCacheAccess
implements CacheAccess {
    private final String cacheDiplayName;
    private final File lockFile;
    private final FileLockManager lockManager;
    private final FileAccess fileAccess = new UnitOfWorkFileAccess();
    private final Set<MultiProcessSafePersistentIndexedCache<?, ?>> caches = new HashSet();
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private Thread owner;
    private FileLockManager.LockMode lockMode;
    private FileLock fileLock;
    private boolean started;
    private final List<String> operationStack = new ArrayList<String>();

    public DefaultCacheAccess(String string, File file, FileLockManager fileLockManager) {
        this.cacheDiplayName = string;
        this.lockFile = file;
        this.lockManager = fileLockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(FileLockManager.LockMode lockMode) {
        this.lock.lock();
        try {
            if (this.owner != null) {
                throw new IllegalStateException(String.format("Cannot open the %s, as it is already in use.", this.cacheDiplayName));
            }
            this.lockMode = lockMode;
            if (lockMode == FileLockManager.LockMode.None) {
                return;
            }
            this.started = true;
            this.fileLock = this.lockManager.lock(this.lockFile, lockMode, this.cacheDiplayName);
            this.lockCache(String.format("Access %s", this.cacheDiplayName));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block7: {
            this.lock.lock();
            try {
                for (MultiProcessSafePersistentIndexedCache<?, ?> multiProcessSafePersistentIndexedCache : this.caches) {
                    multiProcessSafePersistentIndexedCache.close();
                }
                this.operationStack.clear();
                this.started = false;
                this.lockMode = null;
                this.owner = null;
                if (this.fileLock == null) break block7;
                try {
                    this.fileLock.close();
                }
                finally {
                    this.fileLock = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public FileLock getFileLock() {
        return this.fileLock;
    }

    @Override
    public void useCache(String string, final Runnable runnable) {
        this.useCache(string, new Factory<Object>(){

            public Object create() {
                runnable.run();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T useCache(String string, Factory<? extends T> factory) {
        if (this.lockMode == FileLockManager.LockMode.Shared) {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
        this.lockCache(string);
        try {
            Object object;
            block8: {
                boolean bl = this.onStartWork();
                try {
                    object = factory.create();
                    if (!bl) break block8;
                    this.onEndWork();
                }
                catch (Throwable throwable) {
                    if (bl) {
                        this.onEndWork();
                    }
                    throw throwable;
                }
            }
            return (T)object;
        }
        finally {
            this.unlockCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockCache(String string) {
        this.lock.lock();
        try {
            while (this.owner != null && this.owner != Thread.currentThread()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException interruptedException) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)interruptedException);
                }
            }
            this.owner = Thread.currentThread();
            this.operationStack.add(0, string);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockCache() {
        this.lock.lock();
        try {
            this.operationStack.remove(0);
            if (this.operationStack.isEmpty()) {
                this.owner = null;
                this.condition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T longRunningOperation(String string, Factory<? extends T> factory) {
        this.startLongRunningOperation();
        try {
            Object object;
            block7: {
                boolean bl = this.onEndWork();
                try {
                    object = factory.create();
                    if (!bl) break block7;
                    this.onStartWork();
                }
                catch (Throwable throwable) {
                    if (bl) {
                        this.onStartWork();
                    }
                    throw throwable;
                }
            }
            return (T)object;
        }
        finally {
            this.endLongRunningOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLongRunningOperation() {
        this.lock.lock();
        try {
            if (this.owner != Thread.currentThread()) {
                throw new IllegalStateException(String.format("Cannot start long running operation, as the %s has not been locked.", this.cacheDiplayName));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void endLongRunningOperation() {
    }

    @Override
    public void longRunningOperation(String string, final Runnable runnable) {
        this.longRunningOperation(string, new Factory<Object>(){

            public Object create() {
                runnable.run();
                return null;
            }
        });
    }

    public <K, V> PersistentIndexedCache<K, V> newCache(File file, Class<K> clazz, Class<V> clazz2) {
        return this.newCache(file, clazz, new DefaultSerializer(clazz2.getClassLoader()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> PersistentIndexedCache<K, V> newCache(final File file, final Class<K> clazz, final Serializer<V> serializer) {
        Factory factory = new Factory<BTreePersistentIndexedCache<K, V>>(){

            public BTreePersistentIndexedCache<K, V> create() {
                return DefaultCacheAccess.this.doCreateCache(file, new DefaultSerializer(clazz.getClassLoader()), serializer);
            }
        };
        MultiProcessSafePersistentIndexedCache multiProcessSafePersistentIndexedCache = new MultiProcessSafePersistentIndexedCache(factory, this.fileAccess);
        this.lock.lock();
        try {
            this.caches.add(multiProcessSafePersistentIndexedCache);
            if (this.started) {
                multiProcessSafePersistentIndexedCache.onStartWork(this.operationStack.get(0));
            }
        }
        finally {
            this.lock.unlock();
        }
        return multiProcessSafePersistentIndexedCache;
    }

    <K, V> BTreePersistentIndexedCache<K, V> doCreateCache(File file, Serializer<K> serializer, Serializer<V> serializer2) {
        return new BTreePersistentIndexedCache<K, V>(file, serializer, serializer2);
    }

    private boolean onStartWork() {
        if (this.started) {
            return false;
        }
        this.started = true;
        for (MultiProcessSafePersistentIndexedCache<?, ?> multiProcessSafePersistentIndexedCache : this.caches) {
            multiProcessSafePersistentIndexedCache.onStartWork(this.operationStack.get(0));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onEndWork() {
        if (!this.started) {
            return false;
        }
        try {
            for (MultiProcessSafePersistentIndexedCache<?, ?> multiProcessSafePersistentIndexedCache : this.caches) {
                multiProcessSafePersistentIndexedCache.onEndWork();
            }
            if (this.fileLock != null) {
                this.fileLock.close();
            }
        }
        finally {
            this.started = false;
            this.fileLock = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLock getLock() {
        this.lock.lock();
        try {
            if (Thread.currentThread() != this.owner || !this.started) {
                throw new IllegalStateException(String.format("The %s has not been locked.", this.cacheDiplayName));
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.fileLock == null) {
            this.fileLock = this.lockManager.lock(this.lockFile, FileLockManager.LockMode.Exclusive, this.cacheDiplayName, this.operationStack.get(0));
        }
        return this.fileLock;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnitOfWorkFileAccess
    extends AbstractFileAccess {
        private UnitOfWorkFileAccess() {
        }

        @Override
        public <T> T readFromFile(Factory<? extends T> factory) throws LockTimeoutException {
            return DefaultCacheAccess.this.getLock().readFromFile(factory);
        }

        @Override
        public void writeToFile(Runnable runnable) throws LockTimeoutException {
            DefaultCacheAccess.this.getLock().writeToFile(runnable);
        }
    }
}

