/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache;

import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import org.gradle.cache.Serializer;
import org.gradle.util.ClassLoaderObjectInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSerializer<T>
implements Serializer<T> {
    private ClassLoader classLoader;

    public DefaultSerializer() {
        this.classLoader = this.getClass().getClassLoader();
    }

    public DefaultSerializer(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : this.getClass().getClassLoader();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public T read(InputStream inputStream) throws Exception {
        try {
            return (T)new ClassLoaderObjectInputStream(inputStream, this.classLoader).readObject();
        }
        catch (StreamCorruptedException streamCorruptedException) {
            return null;
        }
    }

    @Override
    public void write(OutputStream outputStream, T t) throws Exception {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(t);
        objectOutputStream.flush();
    }
}

