/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.gradle.api.Project;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.internal.StreamingStyledTextOutput;
import org.gradle.util.GUtil;

public class TextReportRenderer
implements ReportRenderer {
    public static final String SEPARATOR = "------------------------------------------------------------";
    private StyledTextOutput textOutput;
    private boolean close;

    public void setOutput(StyledTextOutput styledTextOutput) {
        this.setWriter(styledTextOutput, false);
    }

    public void setOutputFile(File file) throws IOException {
        this.cleanupWriter();
        this.setWriter(new StreamingStyledTextOutput(new BufferedWriter(new FileWriter(file))), true);
    }

    public void startProject(Project project) {
        String string = this.createHeader(project);
        this.writeHeading(string);
    }

    protected String createHeader(Project project) {
        String string = project.getRootProject() == project ? "Root project" : String.format("Project %s", project.getPath());
        if (GUtil.isTrue(project.getDescription())) {
            string = string + " - " + project.getDescription();
        }
        return string;
    }

    public void completeProject(Project project) {
    }

    public void complete() throws IOException {
        this.cleanupWriter();
    }

    private void setWriter(StyledTextOutput styledTextOutput, boolean bl) {
        this.textOutput = styledTextOutput;
        this.close = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupWriter() throws IOException {
        try {
            if (this.textOutput != null && this.close) {
                ((Closeable)((Object)this.textOutput)).close();
            }
        }
        finally {
            this.textOutput = null;
        }
    }

    public StyledTextOutput getTextOutput() {
        return this.textOutput;
    }

    public void writeHeading(String string) {
        this.textOutput.println().style(StyledTextOutput.Style.Header);
        this.textOutput.println(SEPARATOR);
        this.textOutput.println(string);
        this.textOutput.text(SEPARATOR);
        this.textOutput.style(StyledTextOutput.Style.Normal);
        this.textOutput.println().println();
    }

    public void writeSubheading(String string) {
        this.getTextOutput().style(StyledTextOutput.Style.Header).println(string);
        for (int i = 0; i < string.length(); ++i) {
            this.getTextOutput().text("-");
        }
        this.getTextOutput().style(StyledTextOutput.Style.Normal).println();
    }
}

