/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.util.Path;

public class TaskDetailsFactory {
    private final Set<Project> projects;
    private final Project project;

    public TaskDetailsFactory(Project project) {
        this.project = project;
        this.projects = project.getAllprojects();
    }

    public TaskDetails create(final Task task) {
        Project project = task.getProject();
        final String string = this.projects.contains(project) ? this.project.relativeProjectPath(task.getPath()) : task.getPath();
        return new TaskDetails(){

            @Override
            public Path getPath() {
                return Path.path(string);
            }

            @Override
            public String getDescription() {
                return task.getDescription();
            }

            @Override
            public Set<TaskDetails> getDependencies() {
                return Collections.emptySet();
            }

            @Override
            public Set<TaskDetails> getChildren() {
                return Collections.emptySet();
            }
        };
    }
}

