/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Task;
import org.gradle.api.internal.DirectedGraph;
import org.gradle.api.internal.GraphAggregator;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TaskDetailsFactory;
import org.gradle.api.tasks.diagnostics.internal.TaskReportModel;
import org.gradle.util.GUtil;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleProjectTaskReportModel
implements TaskReportModel {
    private final SetMultimap<String, TaskDetails> groups = TreeMultimap.create((Comparator)new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            return string.compareToIgnoreCase(string2);
        }
    }, (Comparator)new Comparator<TaskDetails>(){

        @Override
        public int compare(TaskDetails taskDetails, TaskDetails taskDetails2) {
            return taskDetails.getPath().compareTo(taskDetails2.getPath());
        }
    });
    private final TaskDetailsFactory factory;

    public SingleProjectTaskReportModel(TaskDetailsFactory taskDetailsFactory) {
        this.factory = taskDetailsFactory;
    }

    public void build(final Collection<? extends Task> collection) {
        LinkedHashSet<Task> linkedHashSet = new LinkedHashSet<Task>();
        for (Task object2 : collection) {
            if (!GUtil.isTrue(object2.getGroup())) continue;
            linkedHashSet.add(object2);
        }
        GraphAggregator<Task> graphAggregator = new GraphAggregator<Task>(new DirectedGraph<Task, Object>(){

            @Override
            public void getNodeValues(Task task, Collection<Object> collection3, Collection<Task> collection2) {
                for (Task task2 : task.getTaskDependencies().getDependencies(task)) {
                    if (!SingleProjectTaskReportModel.this.containsTaskWithPath(collection, task2.getPath())) continue;
                    collection2.add(task2);
                }
            }
        });
        GraphAggregator.Result<? extends Task> result = graphAggregator.group(linkedHashSet, collection);
        for (Task task : result.getTopLevelNodes()) {
            TreeSet<? extends Task> treeSet = new TreeSet<Task>(result.getNodes(task));
            LinkedHashSet<TaskDetails> linkedHashSet2 = new LinkedHashSet<TaskDetails>();
            LinkedHashSet<TaskDetails> linkedHashSet3 = new LinkedHashSet<TaskDetails>();
            for (Task task2 : treeSet) {
                if (task2 != task) {
                    linkedHashSet2.add(new TaskDetailsImpl(task2, this.factory.create(task2), Collections.<TaskDetails>emptySet(), Collections.<TaskDetails>emptySet()));
                }
                for (Task task3 : task2.getTaskDependencies().getDependencies(task2)) {
                    if (!linkedHashSet.contains(task3) && this.containsTaskWithPath(collection, task3.getPath())) continue;
                    linkedHashSet3.add(this.factory.create(task3));
                }
            }
            String string = linkedHashSet.contains(task) ? task.getGroup() : "";
            this.groups.put((Object)string, (Object)new TaskDetailsImpl(task, this.factory.create(task), linkedHashSet2, linkedHashSet3));
        }
    }

    private boolean containsTaskWithPath(Collection<? extends Task> collection, String string) {
        for (Task task : collection) {
            if (!task.getPath().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups.keySet();
    }

    @Override
    public Set<TaskDetails> getTasksForGroup(String string) {
        if (!this.groups.containsKey((Object)string)) {
            throw new IllegalArgumentException(String.format("Unknown group '%s'", string));
        }
        return this.groups.get((Object)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskDetailsImpl
    implements TaskDetails {
        private final Task task;
        private final TaskDetails details;
        private final Set<TaskDetails> children;
        private final Set<TaskDetails> dependencies;

        public TaskDetailsImpl(Task task, TaskDetails taskDetails, Set<TaskDetails> set, Set<TaskDetails> set2) {
            this.task = task;
            this.details = taskDetails;
            this.children = set;
            this.dependencies = set2;
        }

        @Override
        public Path getPath() {
            return this.details.getPath();
        }

        @Override
        public String getDescription() {
            return this.details.getDescription();
        }

        public String toString() {
            return this.task.toString();
        }

        public Task getTask() {
            return this.task;
        }

        @Override
        public Set<TaskDetails> getDependencies() {
            return this.dependencies;
        }

        @Override
        public Set<TaskDetails> getChildren() {
            return this.children;
        }
    }
}

