/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import org.gradle.api.Action;
import org.gradle.logging.StyledTextOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphRenderer {
    private final StyledTextOutput output;
    private StringBuilder prefix = new StringBuilder();
    private boolean seenRootChildren;
    private boolean lastChild = true;

    public GraphRenderer(StyledTextOutput styledTextOutput) {
        this.output = styledTextOutput;
    }

    public void visit(Action<? super StyledTextOutput> action, boolean bl) {
        if (this.seenRootChildren) {
            this.output.withStyle(StyledTextOutput.Style.Info).text(this.prefix + (bl ? "\\--- " : "+--- "));
        }
        this.lastChild = bl;
        action.execute(this.output);
        this.output.println();
    }

    public void startChildren() {
        if (this.seenRootChildren) {
            this.prefix.append(this.lastChild ? "     " : "|    ");
        }
        this.seenRootChildren = true;
    }

    public void completeChildren() {
        if (this.prefix.length() == 0) {
            this.seenRootChildren = false;
        } else {
            this.prefix.setLength(this.prefix.length() - 5);
        }
    }
}

