/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.Comparator;
import java.util.Set;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TaskReportModel;
import org.gradle.util.GUtil;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGroupTaskReportModel
implements TaskReportModel {
    public static final String OTHER_GROUP = "other";
    private static final Comparator<String> STRING_COMPARATOR = GUtil.caseInsensitive();
    private SetMultimap<String, TaskDetails> groups;

    public void build(TaskReportModel taskReportModel) {
        Comparator<String> comparator = GUtil.last(GUtil.last(STRING_COMPARATOR, OTHER_GROUP), "");
        Comparator<TaskDetails> comparator2 = new Comparator<TaskDetails>(){

            @Override
            public int compare(TaskDetails taskDetails, TaskDetails taskDetails2) {
                int n = STRING_COMPARATOR.compare(taskDetails.getPath().getName(), taskDetails2.getPath().getName());
                if (n != 0) {
                    return n;
                }
                Path path = taskDetails.getPath().getParent();
                Path path2 = taskDetails2.getPath().getParent();
                if (path == null && path2 != null) {
                    return -1;
                }
                if (path != null && path2 == null) {
                    return 1;
                }
                if (path == null) {
                    return 0;
                }
                return path.compareTo(path2);
            }
        };
        this.groups = TreeMultimap.create(comparator, (Comparator)comparator2);
        for (String string : taskReportModel.getGroups()) {
            this.groups.putAll((Object)string, taskReportModel.getTasksForGroup(string));
        }
        String string = this.findOtherGroup(this.groups.keySet());
        if (string != null && this.groups.keySet().contains("")) {
            this.groups.putAll((Object)string, (Iterable)this.groups.removeAll((Object)""));
        }
        if (this.groups.keySet().contains("") && this.groups.keySet().size() > 1) {
            this.groups.putAll((Object)OTHER_GROUP, (Iterable)this.groups.removeAll((Object)""));
        }
    }

    private String findOtherGroup(Set<String> set) {
        for (String string : set) {
            if (!string.equalsIgnoreCase(OTHER_GROUP)) continue;
            return string;
        }
        return null;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups.keySet();
    }

    @Override
    public Set<TaskDetails> getTasksForGroup(String string) {
        return this.groups.get((Object)string);
    }
}

