/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.tasks.diagnostics.internal.DependencyReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.GraphRenderer;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.logging.StyledTextOutput;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsciiReportRenderer
extends TextReportRenderer
implements DependencyReportRenderer {
    private boolean hasConfigs;
    private boolean hasCyclicDependencies;
    private GraphRenderer renderer;

    @Override
    public void startProject(Project project) {
        super.startProject(project);
        this.hasConfigs = false;
        this.hasCyclicDependencies = false;
    }

    @Override
    public void completeProject(Project project) {
        if (!this.hasConfigs) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println("No configurations");
        }
        super.completeProject(project);
    }

    @Override
    public void startConfiguration(final Configuration configuration) {
        if (this.hasConfigs) {
            this.getTextOutput().println();
        }
        this.hasConfigs = true;
        this.renderer = new GraphRenderer(this.getTextOutput());
        this.renderer.visit((Action<? super StyledTextOutput>)new Action<StyledTextOutput>(){

            @Override
            public void execute(StyledTextOutput styledTextOutput) {
                AsciiReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text(configuration.getName());
                AsciiReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text(AsciiReportRenderer.this.getDescription(configuration));
            }
        }, true);
    }

    private String getDescription(Configuration configuration) {
        return GUtil.isTrue(configuration.getDescription()) ? " - " + configuration.getDescription() : "";
    }

    @Override
    public void completeConfiguration(Configuration configuration) {
    }

    @Override
    public void render(ResolvedConfiguration resolvedConfiguration) throws IOException {
        Set<MergedResolvedDependency> set = this.mergeChildren(resolvedConfiguration.getFirstLevelModuleDependencies());
        if (set.isEmpty()) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).text("No dependencies");
            this.getTextOutput().println();
            return;
        }
        this.renderChildren(set, new HashSet<String>());
    }

    @Override
    public void complete() throws IOException {
        if (this.hasCyclicDependencies) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println("\n(*) - dependencies omitted (listed previously)");
        }
        super.complete();
    }

    private void render(final MergedResolvedDependency mergedResolvedDependency, Set<String> set, boolean bl) {
        final boolean bl2 = set.add(mergedResolvedDependency.getName());
        if (!bl2) {
            this.hasCyclicDependencies = true;
        }
        this.renderer.visit((Action<? super StyledTextOutput>)new Action<StyledTextOutput>(){

            @Override
            public void execute(StyledTextOutput styledTextOutput) {
                AsciiReportRenderer.this.getTextOutput().text(mergedResolvedDependency.getName());
                StyledTextOutput styledTextOutput2 = AsciiReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Info);
                styledTextOutput2.format(" [%s]", mergedResolvedDependency.getConfiguration());
                if (!bl2) {
                    styledTextOutput2.append(" (*)");
                }
            }
        }, bl);
        if (bl2) {
            this.renderChildren(this.mergeChildren(mergedResolvedDependency.getChildren()), set);
        }
    }

    private void renderChildren(Set<MergedResolvedDependency> set, Set<String> set2) {
        this.renderer.startChildren();
        ArrayList<MergedResolvedDependency> arrayList = new ArrayList<MergedResolvedDependency>(set);
        for (int i = 0; i < arrayList.size(); ++i) {
            MergedResolvedDependency mergedResolvedDependency = (MergedResolvedDependency)arrayList.get(i);
            this.render(mergedResolvedDependency, set2, i == arrayList.size() - 1);
        }
        this.renderer.completeChildren();
    }

    private Set<MergedResolvedDependency> mergeChildren(Set<ResolvedDependency> set) {
        LinkedHashMap<String, LinkedHashSet<ResolvedDependency>> linkedHashMap = new LinkedHashMap<String, LinkedHashSet<ResolvedDependency>>();
        for (ResolvedDependency object : set) {
            LinkedHashSet<ResolvedDependency> linkedHashSet2 = (LinkedHashSet<ResolvedDependency>)linkedHashMap.get(object.getName());
            if (linkedHashSet2 == null) {
                linkedHashSet2 = new LinkedHashSet<ResolvedDependency>();
                linkedHashMap.put(object.getName(), linkedHashSet2);
            }
            linkedHashSet2.add(object);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (LinkedHashSet<ResolvedDependency> linkedHashSet2 : linkedHashMap.values()) {
            linkedHashSet.add(new MergedResolvedDependency(linkedHashSet2));
        }
        return linkedHashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MergedResolvedDependency {
        private Set<ResolvedDependency> mergedResolvedDependencies = new LinkedHashSet<ResolvedDependency>();

        public MergedResolvedDependency(Set<ResolvedDependency> set) {
            assert (!set.isEmpty());
            this.mergedResolvedDependencies = set;
        }

        public String getName() {
            return this.mergedResolvedDependencies.iterator().next().getName();
        }

        public String getConfiguration() {
            String string = "";
            for (ResolvedDependency resolvedDependency : this.mergedResolvedDependencies) {
                string = string + resolvedDependency.getConfiguration() + ",";
            }
            return string.substring(0, string.length() - 1);
        }

        public Set<ResolvedDependency> getChildren() {
            LinkedHashSet<ResolvedDependency> linkedHashSet = new LinkedHashSet<ResolvedDependency>();
            for (ResolvedDependency resolvedDependency : this.mergedResolvedDependencies) {
                linkedHashSet.addAll(resolvedDependency.getChildren());
            }
            return linkedHashSet;
        }
    }
}

