/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TaskReportModel;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateMultiProjectTaskReportModel
implements TaskReportModel {
    private List<TaskReportModel> projects = new ArrayList<TaskReportModel>();
    private SetMultimap<String, TaskDetails> groups;
    private final boolean mergeTasksWithSameName;

    public AggregateMultiProjectTaskReportModel(boolean bl) {
        this.mergeTasksWithSameName = bl;
    }

    public void add(TaskReportModel taskReportModel) {
        this.projects.add(taskReportModel);
    }

    public void build() {
        this.groups = TreeMultimap.create((Comparator)new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareToIgnoreCase(string2);
            }
        }, (Comparator)new Comparator<TaskDetails>(){

            @Override
            public int compare(TaskDetails taskDetails, TaskDetails taskDetails2) {
                return taskDetails.getPath().compareTo(taskDetails2.getPath());
            }
        });
        for (TaskReportModel taskReportModel : this.projects) {
            for (String string : taskReportModel.getGroups()) {
                for (TaskDetails taskDetails : taskReportModel.getTasksForGroup(string)) {
                    this.groups.put((Object)string, (Object)(this.mergeTasksWithSameName ? new MergedTaskDetails(taskDetails) : taskDetails));
                }
            }
        }
    }

    @Override
    public Set<String> getGroups() {
        return this.groups.keySet();
    }

    @Override
    public Set<TaskDetails> getTasksForGroup(String string) {
        return this.groups.get((Object)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MergedTaskDetails
    implements TaskDetails {
        private final TaskDetails task;

        public MergedTaskDetails(TaskDetails taskDetails) {
            this.task = taskDetails;
        }

        @Override
        public Path getPath() {
            return Path.path(this.task.getPath().getName());
        }

        @Override
        public Set<TaskDetails> getChildren() {
            return this.task.getChildren();
        }

        @Override
        public String getDescription() {
            return this.task.getDescription();
        }

        @Override
        public Set<TaskDetails> getDependencies() {
            return this.task.getDependencies();
        }
    }
}

