/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.CommandLineOption;
import org.gradle.api.tasks.diagnostics.AbstractReportTask;
import org.gradle.api.tasks.diagnostics.internal.AggregateMultiProjectTaskReportModel;
import org.gradle.api.tasks.diagnostics.internal.DefaultGroupTaskReportModel;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.SingleProjectTaskReportModel;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TaskDetailsFactory;
import org.gradle.api.tasks.diagnostics.internal.TaskReportRenderer;

public class TaskReportTask
extends AbstractReportTask {
    private TaskReportRenderer renderer = new TaskReportRenderer();
    private boolean detail;

    public ReportRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(TaskReportRenderer taskReportRenderer) {
        this.renderer = taskReportRenderer;
    }

    @CommandLineOption(options={"all"}, description="Show additional tasks and detail.")
    public void setShowDetail(boolean bl) {
        this.detail = bl;
    }

    public boolean isDetail() {
        return this.detail;
    }

    public void generate(Project project) throws IOException {
        this.renderer.showDetail(this.isDetail());
        this.renderer.addDefaultTasks(project.getDefaultTasks());
        AggregateMultiProjectTaskReportModel aggregateMultiProjectTaskReportModel = new AggregateMultiProjectTaskReportModel(!this.isDetail());
        TaskDetailsFactory taskDetailsFactory = new TaskDetailsFactory(project);
        SingleProjectTaskReportModel singleProjectTaskReportModel = new SingleProjectTaskReportModel(taskDetailsFactory);
        ProjectInternal projectInternal = (ProjectInternal)project;
        singleProjectTaskReportModel.build((Collection<? extends Task>)Sets.union((Set)projectInternal.getTasks(), (Set)projectInternal.getImplicitTasks()));
        aggregateMultiProjectTaskReportModel.add(singleProjectTaskReportModel);
        for (Project iterator : project.getSubprojects()) {
            SingleProjectTaskReportModel singleProjectTaskReportModel2 = new SingleProjectTaskReportModel(taskDetailsFactory);
            singleProjectTaskReportModel2.build(iterator.getTasks());
            aggregateMultiProjectTaskReportModel.add(singleProjectTaskReportModel2);
        }
        aggregateMultiProjectTaskReportModel.build();
        DefaultGroupTaskReportModel defaultGroupTaskReportModel = new DefaultGroupTaskReportModel();
        defaultGroupTaskReportModel.build(aggregateMultiProjectTaskReportModel);
        for (String string : defaultGroupTaskReportModel.getGroups()) {
            this.renderer.startTaskGroup(string);
            for (TaskDetails taskDetails : defaultGroupTaskReportModel.getTasksForGroup(string)) {
                this.renderer.addTask(taskDetails);
                for (TaskDetails taskDetails2 : taskDetails.getChildren()) {
                    this.renderer.addChildTask(taskDetails2);
                }
            }
        }
        this.renderer.completeTasks();
        for (Rule rule : project.getTasks().getRules()) {
            this.renderer.addRule(rule);
        }
    }
}

