/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.tasks.diagnostics.AbstractReportTask;
import org.gradle.api.tasks.diagnostics.internal.GraphRenderer;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.logging.StyledTextOutput;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectReportTask
extends AbstractReportTask {
    private TextReportRenderer renderer = new TextReportRenderer();

    @Override
    protected TextReportRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    protected void generate(Project project) throws IOException {
        BuildClientMetaData buildClientMetaData = (BuildClientMetaData)this.getServices().get(BuildClientMetaData.class);
        StyledTextOutput styledTextOutput = this.getRenderer().getTextOutput();
        this.render(project, new GraphRenderer(styledTextOutput), true, styledTextOutput);
        if (project.getChildProjects().isEmpty()) {
            styledTextOutput.withStyle(StyledTextOutput.Style.Info).text("No sub-projects");
            styledTextOutput.println();
        }
        styledTextOutput.println();
        styledTextOutput.text("To see a list of the tasks of a project, run ");
        buildClientMetaData.describeCommand(styledTextOutput.withStyle(StyledTextOutput.Style.UserInput), String.format("<project-path>:%s", "tasks"));
        styledTextOutput.println();
        styledTextOutput.text("For example, try running ");
        Project project2 = project.getChildProjects().isEmpty() ? project : this.getChildren(project).get(0);
        buildClientMetaData.describeCommand(styledTextOutput.withStyle(StyledTextOutput.Style.UserInput), project2.absoluteProjectPath("tasks"));
        styledTextOutput.println();
        if (project != project.getRootProject()) {
            styledTextOutput.println();
            styledTextOutput.text("To see a list of all the projects in this build, run ");
            buildClientMetaData.describeCommand(styledTextOutput.withStyle(StyledTextOutput.Style.UserInput), project.getRootProject().absoluteProjectPath("projects"));
            styledTextOutput.println();
        }
    }

    private void render(final Project project, GraphRenderer graphRenderer, boolean bl, final StyledTextOutput styledTextOutput) {
        graphRenderer.visit((Action<? super StyledTextOutput>)new Action<StyledTextOutput>(){

            @Override
            public void execute(StyledTextOutput styledTextOutput2) {
                styledTextOutput2.text(StringUtils.capitalize((String)project.toString()));
                if (GUtil.isTrue(project.getDescription())) {
                    styledTextOutput.withStyle(StyledTextOutput.Style.Description).format(" - %s", project.getDescription());
                }
            }
        }, bl);
        graphRenderer.startChildren();
        List<Project> list = this.getChildren(project);
        for (Project project2 : list) {
            this.render(project2, graphRenderer, project2 == list.get(list.size() - 1), styledTextOutput);
        }
        graphRenderer.completeChildren();
    }

    private List<Project> getChildren(Project project) {
        ArrayList<Project> arrayList = new ArrayList<Project>(project.getChildProjects().values());
        Collections.sort(arrayList);
        return arrayList;
    }
}

