/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.logging.StyledTextOutputFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReportTask
extends ConventionTask {
    private File outputFile;
    private Set<Project> projects;

    protected AbstractReportTask() {
        this.getOutputs().upToDateWhen((Spec<? super Task>)new Spec<Task>(){

            @Override
            public boolean isSatisfiedBy(Task task) {
                return AbstractReportTask.this.getOutputFile() != null;
            }
        });
        this.projects = new HashSet<Project>();
        this.projects.add(this.getProject());
    }

    @TaskAction
    public void generate() {
        try {
            ReportRenderer reportRenderer = this.getRenderer();
            File file = this.getOutputFile();
            if (file != null) {
                reportRenderer.setOutputFile(file);
            } else {
                reportRenderer.setOutput(((StyledTextOutputFactory)this.getServices().get(StyledTextOutputFactory.class)).create(this.getClass()));
            }
            TreeSet<Project> treeSet = new TreeSet<Project>(this.getProjects());
            for (Project project : treeSet) {
                reportRenderer.startProject(project);
                this.generate(project);
                reportRenderer.completeProject(project);
            }
            reportRenderer.complete();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    protected abstract ReportRenderer getRenderer();

    protected abstract void generate(Project var1) throws IOException;

    @OutputFile
    @Optional
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File file) {
        this.outputFile = file;
    }

    public Set<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(Set<Project> set) {
        this.projects = set;
    }
}

