/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.bundling;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.OutputFile;
import org.gradle.util.GUtil;

public abstract class AbstractArchiveTask
extends AbstractCopyTask {
    private File destinationDir;
    private String customName;
    private String baseName;
    private String appendix;
    private String version;
    private String extension;
    private String classifier = "";

    public String getArchiveName() {
        if (this.customName != null) {
            return this.customName;
        }
        String string = GUtil.elvis(this.getBaseName(), "") + this.maybe(this.getBaseName(), this.getAppendix());
        string = string + this.maybe(string, this.getVersion());
        string = string + this.maybe(string, this.getClassifier());
        string = string + (GUtil.isTrue(this.getExtension()) ? "." + this.getExtension() : "");
        return string;
    }

    public void setArchiveName(String string) {
        this.customName = string;
    }

    private String maybe(String string, String string2) {
        if (GUtil.isTrue(string2)) {
            if (GUtil.isTrue(string)) {
                return String.format("-%s", string2);
            }
            return string2;
        }
        return "";
    }

    @OutputFile
    public File getArchivePath() {
        return new File(this.getDestinationDir(), this.getArchiveName());
    }

    public File getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(File file) {
        this.destinationDir = file;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String string) {
        this.baseName = string;
    }

    public String getAppendix() {
        return this.appendix;
    }

    public void setAppendix(String string) {
        this.appendix = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String string) {
        this.classifier = string;
    }

    public AbstractArchiveTask into(Object object) {
        super.into(object);
        return this;
    }

    public AbstractArchiveTask into(Object object, Closure closure) {
        super.into(object, closure);
        return this;
    }
}

