/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.artifacts.ArtifactPublicationServices;
import org.gradle.api.internal.artifacts.ArtifactPublisher;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ConfigureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upload
extends ConventionTask {
    private static Logger logger = LoggerFactory.getLogger(Upload.class);
    private Configuration configuration;
    private boolean uploadDescriptor;
    private File descriptorDestination;
    private RepositoryHandler repositories;
    private ArtifactPublisher artifactPublisher;

    public Upload() {
        ArtifactPublicationServices artifactPublicationServices = (ArtifactPublicationServices)this.getServices().getFactory(ArtifactPublicationServices.class).create();
        this.repositories = artifactPublicationServices.getRepositoryHandler();
        this.artifactPublisher = artifactPublicationServices.getArtifactPublisher();
    }

    @TaskAction
    protected void upload() {
        logger.info("Publishing configuration: " + this.configuration);
        this.artifactPublisher.publish((ConfigurationInternal)this.configuration, this.isUploadDescriptor() ? this.getDescriptorDestination() : null);
    }

    public boolean isUploadDescriptor() {
        return this.uploadDescriptor;
    }

    public void setUploadDescriptor(boolean bl) {
        this.uploadDescriptor = bl;
    }

    public File getDescriptorDestination() {
        return this.descriptorDestination;
    }

    public void setDescriptorDestination(File file) {
        this.descriptorDestination = file;
    }

    public RepositoryHandler getRepositories() {
        return this.repositories;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public RepositoryHandler repositories(Closure closure) {
        return ConfigureUtil.configure(closure, this.repositories);
    }

    @InputFiles
    public FileCollection getArtifacts() {
        Configuration configuration = this.getConfiguration();
        return configuration == null ? null : configuration.getAllArtifacts().getFiles();
    }

    void setRepositories(RepositoryHandler repositoryHandler) {
        this.repositories = repositoryHandler;
    }

    void setArtifactPublisher(ArtifactPublisher artifactPublisher) {
        this.artifactPublisher = artifactPublisher;
    }
}

