/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceTask
extends ConventionTask
implements PatternFilterable {
    private final List<Object> source = new ArrayList<Object>();
    private final PatternFilterable patternSet = new PatternSet();

    @InputFiles
    @SkipWhenEmpty
    public FileTree getSource() {
        FileTree fileTree = this.source.isEmpty() ? DeprecationLogger.whileDisabled(new Factory<FileTree>(){

            public FileTree create() {
                return SourceTask.this.getDefaultSource();
            }
        }) : this.getProject().files(new ArrayList<Object>(this.source)).getAsFileTree();
        return fileTree == null ? this.getProject().files(new Object[0]).getAsFileTree() : fileTree.matching(this.patternSet);
    }

    @Deprecated
    protected FileTree getDefaultSource() {
        DeprecationLogger.nagUserOfReplacedMethod("SourceTask.getDefaultSource()", "getSource()");
        return null;
    }

    public void setSource(Object object) {
        this.source.clear();
        this.source.add(object);
    }

    public SourceTask source(Object ... objectArray) {
        for (Object object : objectArray) {
            this.source.add(object);
        }
        return this;
    }

    @Override
    public SourceTask include(String ... stringArray) {
        this.patternSet.include(stringArray);
        return this;
    }

    @Override
    public SourceTask include(Iterable<String> iterable) {
        this.patternSet.include(iterable);
        return this;
    }

    @Override
    public SourceTask include(Spec<FileTreeElement> spec) {
        this.patternSet.include(spec);
        return this;
    }

    @Override
    public SourceTask include(Closure closure) {
        this.patternSet.include(closure);
        return this;
    }

    @Override
    public SourceTask exclude(String ... stringArray) {
        this.patternSet.exclude(stringArray);
        return this;
    }

    @Override
    public SourceTask exclude(Iterable<String> iterable) {
        this.patternSet.exclude(iterable);
        return this;
    }

    @Override
    public SourceTask exclude(Spec<FileTreeElement> spec) {
        this.patternSet.exclude(spec);
        return this;
    }

    @Override
    public SourceTask exclude(Closure closure) {
        this.patternSet.exclude(closure);
        return this;
    }

    @Override
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    @Override
    public SourceTask setIncludes(Iterable<String> iterable) {
        this.patternSet.setIncludes(iterable);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    @Override
    public SourceTask setExcludes(Iterable<String> iterable) {
        this.patternSet.setExcludes(iterable);
        return this;
    }
}

