/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import groovy.lang.Closure;
import java.io.FilterReader;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.file.copy.CopyActionImpl;
import org.gradle.api.internal.file.copy.CopySpecSource;
import org.gradle.api.internal.file.copy.ReadableCopySpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.Factory;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCopyTask
extends ConventionTask
implements CopySpec,
CopySpecSource {
    @TaskAction
    protected void copy() {
        this.configureRootSpec();
        this.getCopyAction().execute();
        this.setDidWork(this.getCopyAction().getDidWork());
    }

    protected void configureRootSpec() {
        FileCollection fileCollection;
        if (!this.getCopyAction().hasSource() && (fileCollection = this.getDefaultSource()) != null) {
            this.from(fileCollection);
        }
    }

    @Deprecated
    public FileCollection getDefaultSource() {
        DeprecationLogger.nagUserOfReplacedMethod("AbstractCopyTask.getDefaultSource()", "getSource()");
        return null;
    }

    @InputFiles
    @SkipWhenEmpty
    @Optional
    public FileCollection getSource() {
        if (this.getCopyAction().hasSource()) {
            return this.getCopyAction().getAllSource();
        }
        return DeprecationLogger.whileDisabled(new Factory<FileCollection>(){

            public FileCollection create() {
                return AbstractCopyTask.this.getDefaultSource();
            }
        });
    }

    protected abstract CopyActionImpl getCopyAction();

    @Override
    public ReadableCopySpec getRootSpec() {
        return this.getCopyAction().getRootSpec();
    }

    protected CopySpec getMainSpec() {
        return this.getCopyAction();
    }

    @Override
    public boolean isCaseSensitive() {
        return this.getMainSpec().isCaseSensitive();
    }

    @Override
    public void setCaseSensitive(boolean bl) {
        this.getMainSpec().setCaseSensitive(bl);
    }

    @Override
    public boolean getIncludeEmptyDirs() {
        return this.getMainSpec().getIncludeEmptyDirs();
    }

    @Override
    public void setIncludeEmptyDirs(boolean bl) {
        this.getMainSpec().setIncludeEmptyDirs(bl);
    }

    @Override
    public AbstractCopyTask from(Object ... objectArray) {
        this.getMainSpec().from(objectArray);
        return this;
    }

    @Override
    public AbstractCopyTask from(Object object, Closure closure) {
        this.getMainSpec().from(object, closure);
        return this;
    }

    @Override
    public CopySpec with(CopySpec ... copySpecArray) {
        this.getMainSpec().with(copySpecArray);
        return this;
    }

    @Override
    public AbstractCopyTask into(Object object) {
        this.getMainSpec().into(object);
        return this;
    }

    @Override
    public AbstractCopyTask into(Object object, Closure closure) {
        this.getMainSpec().into(object, closure);
        return this;
    }

    @Override
    public AbstractCopyTask include(String ... stringArray) {
        this.getMainSpec().include(stringArray);
        return this;
    }

    @Override
    public AbstractCopyTask include(Iterable<String> iterable) {
        this.getMainSpec().include(iterable);
        return this;
    }

    @Override
    public AbstractCopyTask include(Spec<FileTreeElement> spec) {
        this.getMainSpec().include(spec);
        return this;
    }

    @Override
    public AbstractCopyTask include(Closure closure) {
        this.getMainSpec().include(closure);
        return this;
    }

    @Override
    public AbstractCopyTask exclude(String ... stringArray) {
        this.getMainSpec().exclude(stringArray);
        return this;
    }

    @Override
    public AbstractCopyTask exclude(Iterable<String> iterable) {
        this.getMainSpec().exclude(iterable);
        return this;
    }

    @Override
    public AbstractCopyTask exclude(Spec<FileTreeElement> spec) {
        this.getMainSpec().exclude(spec);
        return this;
    }

    @Override
    public AbstractCopyTask exclude(Closure closure) {
        this.getMainSpec().exclude(closure);
        return this;
    }

    @Override
    public AbstractCopyTask setIncludes(Iterable<String> iterable) {
        this.getMainSpec().setIncludes(iterable);
        return this;
    }

    @Override
    public Set<String> getIncludes() {
        return this.getMainSpec().getIncludes();
    }

    @Override
    public AbstractCopyTask setExcludes(Iterable<String> iterable) {
        this.getMainSpec().setExcludes(iterable);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        return this.getMainSpec().getExcludes();
    }

    @Override
    public AbstractCopyTask rename(Closure closure) {
        this.getMainSpec().rename(closure);
        return this;
    }

    @Override
    public AbstractCopyTask rename(String string, String string2) {
        this.getMainSpec().rename(string, string2);
        return this;
    }

    @Override
    public AbstractCopyTask rename(Pattern pattern, String string) {
        this.getMainSpec().rename(pattern, string);
        return this;
    }

    @Override
    public AbstractCopyTask filter(Map<String, ?> map, Class<? extends FilterReader> clazz) {
        this.getMainSpec().filter(map, clazz);
        return this;
    }

    @Override
    public AbstractCopyTask filter(Class<? extends FilterReader> clazz) {
        this.getMainSpec().filter(clazz);
        return this;
    }

    @Override
    public AbstractCopyTask filter(Closure closure) {
        this.getMainSpec().filter(closure);
        return this;
    }

    @Override
    public AbstractCopyTask expand(Map<String, ?> map) {
        this.getMainSpec().expand(map);
        return this;
    }

    @Override
    public Integer getDirMode() {
        return this.getMainSpec().getDirMode();
    }

    @Override
    public Integer getFileMode() {
        return this.getMainSpec().getFileMode();
    }

    @Override
    public AbstractCopyTask setDirMode(Integer n) {
        this.getMainSpec().setDirMode(n);
        return this;
    }

    @Override
    public AbstractCopyTask setFileMode(Integer n) {
        this.getMainSpec().setFileMode(n);
        return this;
    }

    @Override
    public AbstractCopyTask eachFile(Action<? super FileCopyDetails> action) {
        this.getMainSpec().eachFile(action);
        return this;
    }

    @Override
    public AbstractCopyTask eachFile(Closure closure) {
        this.getMainSpec().eachFile(closure);
        return this;
    }
}

