/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.specs;

import groovy.lang.Closure;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.OrSpec;
import org.gradle.api.specs.Spec;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Specs {
    public static final Spec<Object> SATISFIES_ALL = new Spec<Object>(){

        @Override
        public boolean isSatisfiedBy(Object object) {
            return true;
        }
    };
    public static final Spec<Object> SATISFIES_NONE = new Spec<Object>(){

        @Override
        public boolean isSatisfiedBy(Object object) {
            return false;
        }
    };

    public static <T> Spec<T> satisfyAll() {
        return SATISFIES_ALL;
    }

    public static <T> Spec<T> satisfyNone() {
        return SATISFIES_NONE;
    }

    public static <T> Spec<T> convertClosureToSpec(final Closure closure) {
        return new Spec<T>(){

            @Override
            public boolean isSatisfiedBy(T t) {
                Object object = closure.call(t);
                return object == null ? false : (Boolean)object;
            }
        };
    }

    public static <T> Set<T> filterIterable(Iterable<? extends T> iterable, Spec<? super T> spec) {
        DeprecationLogger.nagUserOfReplacedMethod("Specs.filterIterable", "CollectionUtils.filter");
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>();
        for (T t : iterable) {
            if (!spec.isSatisfiedBy(t)) continue;
            linkedHashSet.add(t);
        }
        return linkedHashSet;
    }

    public static <T> AndSpec<T> and(Spec<? super T> ... specArray) {
        return new AndSpec<T>(specArray);
    }

    public static <T> OrSpec<T> or(Spec<? super T> ... specArray) {
        return new OrSpec<T>(specArray);
    }

    public static <T> NotSpec<T> not(Spec<? super T> spec) {
        return new NotSpec<T>(spec);
    }

    public static <T> Spec<T> or(final boolean bl, List<? extends Spec<? super T>> list) {
        if (list.isEmpty()) {
            return new Spec<T>(){

                @Override
                public boolean isSatisfiedBy(T t) {
                    return bl;
                }
            };
        }
        return new OrSpec(list.toArray(new Spec[list.size()]));
    }
}

