/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.specs;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeSpec<T>
implements Spec<T> {
    private List<Spec<? super T>> specs;

    protected CompositeSpec(Spec<? super T> ... specArray) {
        this.specs = Lists.newArrayList((Object[])specArray);
    }

    protected CompositeSpec(Iterable<? extends Spec<? super T>> iterable) {
        this.specs = Lists.newArrayList(iterable);
    }

    public List<Spec<? super T>> getSpecs() {
        return Collections.unmodifiableList(this.specs);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CompositeSpec)) {
            return false;
        }
        CompositeSpec compositeSpec = (CompositeSpec)object;
        return !(this.specs != null ? !this.specs.equals(compositeSpec.specs) : compositeSpec.specs != null);
    }

    public int hashCode() {
        return this.specs != null ? this.specs.hashCode() : 0;
    }
}

