/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.logging;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Logging {
    public static final Marker LIFECYCLE = MarkerFactory.getDetachedMarker((String)"LIFECYCLE");
    public static final Marker QUIET = MarkerFactory.getDetachedMarker((String)"QUIET");
    public static final Map<Integer, LogLevel> ANT_IVY_2_SLF4J_LEVEL_MAPPER = new HashMap<Integer, LogLevel>(){
        {
            this.put(0, LogLevel.ERROR);
            this.put(1, LogLevel.WARN);
            this.put(2, LogLevel.INFO);
            this.put(4, LogLevel.DEBUG);
            this.put(3, LogLevel.DEBUG);
        }
    };

    public static Logger getLogger(Class clazz) {
        return new LoggerImpl(LoggerFactory.getLogger((Class)clazz));
    }

    public static Logger getLogger(String string) {
        return new LoggerImpl(LoggerFactory.getLogger((String)string));
    }

    private static class LoggerImpl
    implements Logger {
        private final org.slf4j.Logger logger;

        public LoggerImpl(org.slf4j.Logger logger) {
            this.logger = logger;
        }

        public boolean isEnabled(LogLevel logLevel) {
            return logLevel.isEnabled(this);
        }

        public void log(LogLevel logLevel, String string) {
            logLevel.log(this, string);
        }

        public void log(LogLevel logLevel, String string, Object ... objectArray) {
            logLevel.log((Logger)this, string, objectArray);
        }

        public void log(LogLevel logLevel, String string, Throwable throwable) {
            logLevel.log((Logger)this, string, throwable);
        }

        public boolean isLifecycleEnabled() {
            return this.logger.isInfoEnabled(LIFECYCLE);
        }

        public void lifecycle(String string) {
            this.logger.info(LIFECYCLE, string);
        }

        public void lifecycle(String string, Object ... objectArray) {
            this.logger.info(LIFECYCLE, string, objectArray);
        }

        public void lifecycle(String string, Throwable throwable) {
            this.logger.info(LIFECYCLE, string, throwable);
        }

        public boolean isQuietEnabled() {
            return this.logger.isInfoEnabled(QUIET);
        }

        public void quiet(String string) {
            this.logger.info(QUIET, string);
        }

        public void quiet(String string, Object ... objectArray) {
            this.logger.info(QUIET, string, objectArray);
        }

        public void quiet(String string, Throwable throwable) {
            this.logger.info(QUIET, string, throwable);
        }

        public void debug(Marker marker, String string) {
            this.logger.debug(marker, string);
        }

        public void debug(Marker marker, String string, Object object) {
            this.logger.debug(marker, string, object);
        }

        public void debug(Marker marker, String string, Object object, Object object2) {
            this.logger.debug(marker, string, object, object2);
        }

        public void debug(Marker marker, String string, Object[] objectArray) {
            this.logger.debug(marker, string, objectArray);
        }

        public void debug(Marker marker, String string, Throwable throwable) {
            this.logger.debug(marker, string, throwable);
        }

        public void debug(String string) {
            this.logger.debug(string);
        }

        public void debug(String string, Object object) {
            this.logger.debug(string, object);
        }

        public void debug(String string, Object object, Object object2) {
            this.logger.debug(string, object, object2);
        }

        public void debug(String string, Object[] objectArray) {
            this.logger.debug(string, objectArray);
        }

        public void debug(String string, Throwable throwable) {
            this.logger.debug(string, throwable);
        }

        public void error(Marker marker, String string) {
            this.logger.error(marker, string);
        }

        public void error(Marker marker, String string, Object object) {
            this.logger.error(marker, string, object);
        }

        public void error(Marker marker, String string, Object object, Object object2) {
            this.logger.error(marker, string, object, object2);
        }

        public void error(Marker marker, String string, Object[] objectArray) {
            this.logger.error(marker, string, objectArray);
        }

        public void error(Marker marker, String string, Throwable throwable) {
            this.logger.error(marker, string, throwable);
        }

        public void error(String string) {
            this.logger.error(string);
        }

        public void error(String string, Object object) {
            this.logger.error(string, object);
        }

        public void error(String string, Object object, Object object2) {
            this.logger.error(string, object, object2);
        }

        public void error(String string, Object[] objectArray) {
            this.logger.error(string, objectArray);
        }

        public void error(String string, Throwable throwable) {
            this.logger.error(string, throwable);
        }

        public String getName() {
            return this.logger.getName();
        }

        public void info(Marker marker, String string) {
            this.logger.info(marker, string);
        }

        public void info(Marker marker, String string, Object object) {
            this.logger.info(marker, string, object);
        }

        public void info(Marker marker, String string, Object object, Object object2) {
            this.logger.info(marker, string, object, object2);
        }

        public void info(Marker marker, String string, Object[] objectArray) {
            this.logger.info(marker, string, objectArray);
        }

        public void info(Marker marker, String string, Throwable throwable) {
            this.logger.info(marker, string, throwable);
        }

        public void info(String string) {
            this.logger.info(string);
        }

        public void info(String string, Object object) {
            this.logger.info(string, object);
        }

        public void info(String string, Object object, Object object2) {
            this.logger.info(string, object, object2);
        }

        public void info(String string, Object[] objectArray) {
            this.logger.info(string, objectArray);
        }

        public void info(String string, Throwable throwable) {
            this.logger.info(string, throwable);
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public boolean isDebugEnabled(Marker marker) {
            return this.logger.isDebugEnabled(marker);
        }

        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        public boolean isErrorEnabled(Marker marker) {
            return this.logger.isErrorEnabled(marker);
        }

        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        public boolean isInfoEnabled(Marker marker) {
            return this.logger.isInfoEnabled(marker);
        }

        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        public boolean isTraceEnabled(Marker marker) {
            return this.logger.isTraceEnabled(marker);
        }

        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        public boolean isWarnEnabled(Marker marker) {
            return this.logger.isWarnEnabled(marker);
        }

        public void trace(Marker marker, String string) {
            this.logger.trace(marker, string);
        }

        public void trace(Marker marker, String string, Object object) {
            this.logger.trace(marker, string, object);
        }

        public void trace(Marker marker, String string, Object object, Object object2) {
            this.logger.trace(marker, string, object, object2);
        }

        public void trace(Marker marker, String string, Object[] objectArray) {
            this.logger.trace(marker, string, objectArray);
        }

        public void trace(Marker marker, String string, Throwable throwable) {
            this.logger.trace(marker, string, throwable);
        }

        public void trace(String string) {
            this.logger.trace(string);
        }

        public void trace(String string, Object object) {
            this.logger.trace(string, object);
        }

        public void trace(String string, Object object, Object object2) {
            this.logger.trace(string, object, object2);
        }

        public void trace(String string, Object[] objectArray) {
            this.logger.trace(string, objectArray);
        }

        public void trace(String string, Throwable throwable) {
            this.logger.trace(string, throwable);
        }

        public void warn(Marker marker, String string) {
            this.logger.warn(marker, string);
        }

        public void warn(Marker marker, String string, Object object) {
            this.logger.warn(marker, string, object);
        }

        public void warn(Marker marker, String string, Object object, Object object2) {
            this.logger.warn(marker, string, object, object2);
        }

        public void warn(Marker marker, String string, Object[] objectArray) {
            this.logger.warn(marker, string, objectArray);
        }

        public void warn(Marker marker, String string, Throwable throwable) {
            this.logger.warn(marker, string, throwable);
        }

        public void warn(String string) {
            this.logger.warn(string);
        }

        public void warn(String string, Object object) {
            this.logger.warn(string, object);
        }

        public void warn(String string, Object object, Object object2) {
            this.logger.warn(string, object, object2);
        }

        public void warn(String string, Object[] objectArray) {
            this.logger.warn(string, objectArray);
        }

        public void warn(String string, Throwable throwable) {
            this.logger.warn(string, throwable);
        }
    }
}

