/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipUpToDateTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipUpToDateTaskExecuter.class);
    private final TaskExecuter executer;
    private final TaskArtifactStateRepository repository;

    public SkipUpToDateTaskExecuter(TaskExecuter taskExecuter, TaskArtifactStateRepository taskArtifactStateRepository) {
        this.executer = taskExecuter;
        this.repository = taskArtifactStateRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TaskInternal taskInternal, TaskStateInternal taskStateInternal) {
        LOGGER.debug("Determining if {} is up-to-date", (Object)taskInternal);
        TaskArtifactState taskArtifactState = this.repository.getStateFor(taskInternal);
        try {
            if (taskArtifactState.isUpToDate()) {
                LOGGER.info("Skipping {} as it is up-to-date", (Object)taskInternal);
                taskStateInternal.upToDate();
                return;
            }
            LOGGER.debug("{} is not up-to-date", (Object)taskInternal);
            taskArtifactState.beforeTask();
            taskInternal.getOutputs().setHistory(taskArtifactState.getExecutionHistory());
            try {
                this.executer.execute(taskInternal, taskStateInternal);
                if (taskStateInternal.getFailure() == null) {
                    taskArtifactState.afterTask();
                }
            }
            finally {
                taskInternal.getOutputs().setHistory(null);
            }
        }
        finally {
            taskArtifactState.finished();
        }
    }
}

