/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class SkipTaskWithNoActionsExecuter
implements TaskExecuter {
    private static final Logger LOGGER = Logging.getLogger(SkipTaskWithNoActionsExecuter.class);
    private final TaskExecuter executer;

    public SkipTaskWithNoActionsExecuter(TaskExecuter taskExecuter) {
        this.executer = taskExecuter;
    }

    public void execute(TaskInternal taskInternal, TaskStateInternal taskStateInternal) {
        if (taskInternal.getActions().isEmpty()) {
            LOGGER.info("Skipping {} as it has no actions.", taskInternal);
            boolean bl = true;
            for (Task task : taskInternal.getTaskDependencies().getDependencies(taskInternal)) {
                if (task.getState().getSkipped()) continue;
                bl = false;
                break;
            }
            if (bl) {
                taskStateInternal.upToDate();
            }
            return;
        }
        this.executer.execute(taskInternal, taskStateInternal);
    }
}

