/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.GradleException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class SkipOnlyIfTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = Logging.getLogger(SkipOnlyIfTaskExecuter.class);
    private final TaskExecuter executer;

    public SkipOnlyIfTaskExecuter(TaskExecuter taskExecuter) {
        this.executer = taskExecuter;
    }

    public void execute(TaskInternal taskInternal, TaskStateInternal taskStateInternal) {
        boolean bl;
        try {
            bl = !taskInternal.getOnlyIf().isSatisfiedBy(taskInternal);
        }
        catch (Throwable throwable) {
            taskStateInternal.executed(new GradleException(String.format("Could not evaluate onlyIf predicate for %s.", taskInternal), throwable));
            return;
        }
        if (bl) {
            LOGGER.info("Skipping {} as task onlyIf is false.", taskInternal);
            taskStateInternal.skipped("SKIPPED");
            return;
        }
        this.executer.execute(taskInternal, taskStateInternal);
    }
}

