/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class SkipEmptySourceFilesTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = Logging.getLogger(SkipEmptySourceFilesTaskExecuter.class);
    private final TaskExecuter executer;

    public SkipEmptySourceFilesTaskExecuter(TaskExecuter taskExecuter) {
        this.executer = taskExecuter;
    }

    public void execute(TaskInternal taskInternal, TaskStateInternal taskStateInternal) {
        if (taskInternal.getInputs().getHasSourceFiles() && taskInternal.getInputs().getSourceFiles().isEmpty()) {
            LOGGER.info("Skipping {} as it has no source files.", taskInternal);
            taskStateInternal.upToDate();
            return;
        }
        this.executer.execute(taskInternal, taskStateInternal);
    }
}

