/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.StopActionException;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskExecutionException;

public class ExecuteActionsTaskExecuter
implements TaskExecuter {
    private static Logger logger = Logging.getLogger(ExecuteActionsTaskExecuter.class);
    private final TaskActionListener listener;

    public ExecuteActionsTaskExecuter(TaskActionListener taskActionListener) {
        this.listener = taskActionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TaskInternal taskInternal, TaskStateInternal taskStateInternal) {
        this.listener.beforeActions(taskInternal);
        taskStateInternal.setExecuting(true);
        try {
            GradleException gradleException = this.executeActions(taskInternal, taskStateInternal);
            taskStateInternal.executed(gradleException);
        }
        finally {
            taskStateInternal.setExecuting(false);
            this.listener.afterActions(taskInternal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GradleException executeActions(TaskInternal taskInternal, TaskStateInternal taskStateInternal) {
        logger.debug("Executing actions for {}.", taskInternal);
        for (Action<? super Task> action : taskInternal.getActions()) {
            taskStateInternal.setDidWork(true);
            taskInternal.getStandardOutputCapture().start();
            try {
                action.execute(taskInternal);
            }
            catch (StopActionException stopActionException) {
                logger.debug("Action stopped by some action with message: {}", stopActionException.getMessage());
            }
            catch (StopExecutionException stopExecutionException) {
                logger.info("Execution stopped by some action with message: {}", stopExecutionException.getMessage());
                break;
            }
            catch (Throwable throwable) {
                TaskExecutionException taskExecutionException = new TaskExecutionException(taskInternal, throwable);
                return taskExecutionException;
            }
            finally {
                taskInternal.getStandardOutputCapture().stop();
            }
        }
        return null;
    }
}

