/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskOutputs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskOutputs
implements TaskOutputsInternal {
    private final DefaultConfigurableFileCollection outputFiles;
    private AndSpec<TaskInternal> upToDateSpec = new AndSpec(new Spec[0]);
    private TaskExecutionHistory history;

    public DefaultTaskOutputs(FileResolver fileResolver, TaskInternal taskInternal) {
        this.outputFiles = new DefaultConfigurableFileCollection(String.format("%s output files", taskInternal), fileResolver, null, new Object[0]);
        this.outputFiles.builtBy(taskInternal);
    }

    @Override
    public Spec<? super TaskInternal> getUpToDateSpec() {
        return this.upToDateSpec;
    }

    @Override
    public void upToDateWhen(Closure closure) {
        this.upToDateSpec = this.upToDateSpec.and(closure);
    }

    @Override
    public void upToDateWhen(Spec<? super Task> spec) {
        this.upToDateSpec = this.upToDateSpec.and(spec);
    }

    @Override
    public boolean getHasOutput() {
        return !this.outputFiles.getFrom().isEmpty() || !this.upToDateSpec.getSpecs().isEmpty();
    }

    @Override
    public FileCollection getFiles() {
        return this.outputFiles;
    }

    @Override
    public TaskOutputs files(Object ... objectArray) {
        this.outputFiles.from(objectArray);
        return this;
    }

    @Override
    public TaskOutputs file(Object object) {
        this.files(object);
        return this;
    }

    @Override
    public TaskOutputs dir(Object object) {
        this.files(object);
        return this;
    }

    @Override
    public FileCollection getPreviousFiles() {
        if (this.history == null) {
            throw new IllegalStateException("Task history is currently not available for this task.");
        }
        return this.history.getOutputFiles();
    }

    @Override
    public void setHistory(TaskExecutionHistory taskExecutionHistory) {
        this.history = taskExecutionHistory;
    }
}

