/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskInputs
implements TaskInputs {
    private final DefaultConfigurableFileCollection inputFiles;
    private final DefaultConfigurableFileCollection sourceFiles;
    private final FileResolver resolver;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public DefaultTaskInputs(FileResolver fileResolver, TaskInternal taskInternal) {
        this.resolver = fileResolver;
        this.inputFiles = new DefaultConfigurableFileCollection(String.format("%s input files", taskInternal), fileResolver, null, new Object[0]);
        this.sourceFiles = new DefaultConfigurableFileCollection(String.format("%s source files", taskInternal), fileResolver, null, new Object[0]);
    }

    @Override
    public boolean getHasInputs() {
        return !this.inputFiles.getFrom().isEmpty() || !this.properties.isEmpty() || !this.sourceFiles.getFrom().isEmpty();
    }

    @Override
    public FileCollection getFiles() {
        return new UnionFileCollection(this.inputFiles, this.sourceFiles);
    }

    @Override
    public TaskInputs files(Object ... objectArray) {
        this.inputFiles.from(objectArray);
        return this;
    }

    @Override
    public TaskInputs file(Object object) {
        this.files(object);
        return this;
    }

    @Override
    public TaskInputs dir(Object object) {
        this.inputFiles.from(this.resolver.resolveFilesAsTree(object));
        return this;
    }

    @Override
    public boolean getHasSourceFiles() {
        return !this.sourceFiles.getFrom().isEmpty();
    }

    @Override
    public FileCollection getSourceFiles() {
        return this.sourceFiles;
    }

    @Override
    public TaskInputs source(Object ... objectArray) {
        this.sourceFiles.from(objectArray);
        return this;
    }

    @Override
    public TaskInputs source(Object object) {
        this.sourceFiles.from(object);
        return this;
    }

    @Override
    public TaskInputs sourceDir(Object object) {
        this.sourceFiles.from(this.resolver.resolveFilesAsTree(object));
        return this;
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Object object = this.unwrap(entry.getValue());
            hashMap.put(entry.getKey(), object);
        }
        return hashMap;
    }

    private Object unwrap(Object object) {
        Object object2;
        while (true) {
            if (object instanceof Callable) {
                object2 = (Callable)object;
                try {
                    object = object2.call();
                }
                catch (Exception exception) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)exception);
                }
            }
            if (!(object instanceof Closure)) break;
            object2 = (Closure)object;
            object = object2.call();
        }
        if (object instanceof FileCollection) {
            object2 = (FileCollection)object;
            return object2.getFiles();
        }
        return object;
    }

    @Override
    public TaskInputs property(String string, Object object) {
        this.properties.put(string, object);
        return this;
    }

    @Override
    public TaskInputs properties(Map<String, ?> map) {
        this.properties.putAll(map);
        return this;
    }
}

