/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Buildable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.UncheckedException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskDependency
extends AbstractTaskDependency {
    private static final TaskResolver FAILING_RESOLVER = new TaskResolver(){

        public Task resolveTask(Object object) {
            throw new IllegalArgumentException(String.format("Cannot convert %s to a task.", object));
        }
    };
    private final Set<Object> values = new HashSet<Object>();
    private final TaskResolver resolver;

    public DefaultTaskDependency() {
        this(null);
    }

    public DefaultTaskDependency(TaskResolver taskResolver) {
        this.resolver = taskResolver == null ? FAILING_RESOLVER : taskResolver;
    }

    @Override
    public void resolve(TaskDependencyResolveContext taskDependencyResolveContext) {
        LinkedList<Object> linkedList = new LinkedList<Object>(this.values);
        while (!linkedList.isEmpty()) {
            Object object;
            Object object2;
            Object object3 = linkedList.removeFirst();
            if (object3 instanceof Buildable) {
                taskDependencyResolveContext.add(object3);
                continue;
            }
            if (object3 instanceof Task) {
                taskDependencyResolveContext.add(object3);
                continue;
            }
            if (object3 instanceof TaskDependency) {
                taskDependencyResolveContext.add(object3);
                continue;
            }
            if (object3 instanceof Closure) {
                object2 = (Closure)object3;
                object = object2.call((Object)taskDependencyResolveContext.getTask());
                if (object == null) continue;
                linkedList.add(0, object);
                continue;
            }
            if (object3 instanceof Iterable) {
                object2 = (Iterable)object3;
                linkedList.addAll(0, GUtil.addToCollection(new ArrayList(), new Iterable[]{object2}));
                continue;
            }
            if (object3 instanceof Map) {
                object2 = (Map)object3;
                linkedList.addAll(0, object2.values());
                continue;
            }
            if (object3 instanceof Object[]) {
                object2 = (Object[])object3;
                linkedList.addAll(0, Arrays.asList(object2));
                continue;
            }
            if (object3 instanceof Callable) {
                object2 = (Callable)object3;
                try {
                    object = object2.call();
                }
                catch (Exception exception) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)exception);
                }
                if (object == null) continue;
                linkedList.add(0, object);
                continue;
            }
            taskDependencyResolveContext.add(this.resolver.resolveTask(object3));
        }
    }

    public Set<Object> getValues() {
        return this.values;
    }

    public void setValues(Iterable<?> iterable) {
        this.values.clear();
        for (Object obj : iterable) {
            this.addValue(obj);
        }
    }

    public DefaultTaskDependency add(Object ... objectArray) {
        for (Object object : objectArray) {
            this.addValue(object);
        }
        return this;
    }

    private void addValue(Object object) {
        if (object == null) {
            throw new InvalidUserDataException("A dependency must not be empty");
        }
        this.values.add(object);
    }
}

