/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.Instantiator;
import org.gradle.api.internal.NamedDomainObjectContainerConfigureDelegate;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.DefaultTaskCollection;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskContainer
extends DefaultTaskCollection<Task>
implements TaskContainerInternal {
    private final ITaskFactory taskFactory;

    public DefaultTaskContainer(ProjectInternal projectInternal, Instantiator instantiator, ITaskFactory iTaskFactory) {
        super(Task.class, instantiator, projectInternal);
        this.taskFactory = iTaskFactory;
    }

    @Override
    public Task add(Map<String, ?> map) {
        HashMap hashMap = new HashMap(map);
        Object v = hashMap.remove("overwrite");
        boolean bl = v != null && "true".equals(v.toString());
        TaskInternal taskInternal = this.taskFactory.createTask(this.project, hashMap);
        String string = taskInternal.getName();
        Task task = (Task)this.findByNameWithoutRules(string);
        if (task != null) {
            if (bl) {
                this.remove(task);
            } else {
                throw new InvalidUserDataException(String.format("Cannot add %s as a task with that name already exists.", taskInternal));
            }
        }
        this.add(taskInternal);
        return taskInternal;
    }

    @Override
    public Task add(Map<String, ?> map, Closure closure) throws InvalidUserDataException {
        return this.add(map).configure(closure);
    }

    @Override
    public <T extends Task> T add(String string, Class<T> clazz) {
        return (T)((Task)clazz.cast(this.add(GUtil.map("name", string, "type", clazz))));
    }

    @Override
    public Task create(String string) {
        return this.add(string);
    }

    @Override
    public Task add(String string) {
        return this.add(GUtil.map("name", string));
    }

    @Override
    public Task replace(String string) {
        return this.add(GUtil.map("name", string, "overwrite", true));
    }

    @Override
    public Task create(String string, Closure closure) {
        return this.add(string, closure);
    }

    @Override
    public Task add(String string, Closure closure) {
        return this.add(GUtil.map("name", string)).configure(closure);
    }

    @Override
    public <T extends Task> T replace(String string, Class<T> clazz) {
        return (T)((Task)clazz.cast(this.add(GUtil.map("name", string, "type", clazz, "overwrite", true))));
    }

    @Override
    public Task findByPath(String string) {
        if (!GUtil.isTrue(string)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        if (!string.contains(":")) {
            return (Task)this.findByName(string);
        }
        String string2 = StringUtils.substringBeforeLast((String)string, (String)":");
        ProjectInternal projectInternal = this.project.findProject(!GUtil.isTrue(string2) ? ":" : string2);
        if (projectInternal == null) {
            return null;
        }
        return (Task)projectInternal.getTasks().findByName(StringUtils.substringAfterLast((String)string, (String)":"));
    }

    @Override
    public Task resolveTask(Object object) {
        if (!GUtil.isTrue(object)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        if (!(object instanceof CharSequence)) {
            DeprecationLogger.nagUserWith(String.format("Converting class %s to a task dependency using toString(). This has been deprecated and will be removed in the next version of Gradle. Please use org.gradle.api.Task, java.lang.String, org.gradle.api.Buildable, org.gradle.tasks.TaskDependency or a Closure to declare your task dependencies.", object.getClass().getName()));
        }
        return this.getByPath(object.toString());
    }

    @Override
    public Task getByPath(String string) throws UnknownTaskException {
        Task task = this.findByPath(string);
        if (task == null) {
            throw new UnknownTaskException(String.format("Task with path '%s' not found in %s.", string, this.project));
        }
        return task;
    }

    protected Object createConfigureDelegate(Closure closure) {
        return new NamedDomainObjectContainerConfigureDelegate(closure.getOwner(), this);
    }

    @Override
    public TaskContainerInternal configure(Closure closure) {
        ConfigureUtil.configure(closure, this.createConfigureDelegate(closure));
        return this;
    }

    @Override
    public DynamicObject getTasksAsDynamicObject() {
        return this.getElementsAsDynamicObject();
    }
}

