/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.gradle.api.Buildable;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.internal.CachingDirectedGraphWalker;
import org.gradle.api.internal.DirectedGraph;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingTaskDependencyResolveContext
implements TaskDependencyResolveContext,
TaskDependency {
    private final LinkedList<Object> queue = new LinkedList();
    private final CachingDirectedGraphWalker<Object, Task> walker = new CachingDirectedGraphWalker<Object, Task>(new TaskGraphImpl());
    private Task task;

    @Override
    public Set<? extends Task> getDependencies(Task task) {
        this.add(task.getTaskDependencies());
        return this.resolve(task);
    }

    @Override
    public Task getTask() {
        return this.task;
    }

    public Set<Task> resolve(Task task) {
        this.task = task;
        try {
            Set<Task> set = this.doResolve();
            return set;
        }
        catch (Exception exception) {
            throw new GradleException(String.format("Could not determine the dependencies of %s.", task), exception);
        }
        finally {
            this.queue.clear();
            this.task = null;
        }
    }

    private Set<Task> doResolve() {
        this.walker.add((Iterable<Object>)this.queue);
        return this.walker.findValues();
    }

    @Override
    public void add(Object object) {
        this.queue.add(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskGraphImpl
    implements DirectedGraph<Object, Task> {
        private TaskGraphImpl() {
        }

        @Override
        public void getNodeValues(Object object, Collection<Task> collection, Collection<Object> collection2) {
            if (object instanceof TaskDependencyInternal) {
                TaskDependencyInternal taskDependencyInternal = (TaskDependencyInternal)object;
                CachingTaskDependencyResolveContext.this.queue.clear();
                taskDependencyInternal.resolve(CachingTaskDependencyResolveContext.this);
                collection2.addAll(CachingTaskDependencyResolveContext.this.queue);
            } else if (object instanceof Buildable) {
                Buildable buildable = (Buildable)object;
                collection2.add(buildable.getBuildDependencies());
            } else if (object instanceof TaskDependency) {
                TaskDependency taskDependency = (TaskDependency)object;
                collection.addAll(taskDependency.getDependencies(CachingTaskDependencyResolveContext.this.task));
            } else if (object instanceof Task) {
                collection.add((Task)object);
            } else {
                throw new IllegalArgumentException(String.format("Cannot resolve object of unknown type %s to a Task.", object.getClass().getSimpleName()));
            }
        }
    }
}

