/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.MaybeCompressedFileResource;
import org.gradle.api.internal.file.archive.compression.Bzip2Archiver;
import org.gradle.api.internal.file.archive.compression.GzipArchiver;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.resources.ResourceHandler;

public class DefaultResourceHandler
implements ResourceHandler {
    private final FileResolver resolver;

    public DefaultResourceHandler(FileResolver fileResolver) {
        this.resolver = fileResolver;
    }

    public ReadableResource gzip(Object object) {
        return new GzipArchiver(this.resolver.resolveResource(object));
    }

    public ReadableResource bzip2(Object object) {
        return new Bzip2Archiver(this.resolver.resolveResource(object));
    }

    public ReadableResource maybeCompressed(Object object) {
        if (object instanceof ReadableResource) {
            return (ReadableResource)object;
        }
        return new MaybeCompressedFileResource(this.resolver.resolveResource(object));
    }
}

