/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import groovy.lang.Closure;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.tasks.TaskInstantiationException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskFactory
implements ITaskFactory {
    public static final String GENERATE_SUBCLASS = "generateSubclass";
    private final ClassGenerator generator;

    public TaskFactory(ClassGenerator classGenerator) {
        this.generator = classGenerator;
    }

    @Override
    public TaskInternal createTask(ProjectInternal projectInternal, Map<String, ?> map) {
        Object v;
        Object v2;
        Object v3;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
        this.checkTaskArgsAndCreateDefaultValues(hashMap);
        String string = hashMap.get("name").toString();
        if (!GUtil.isTrue(string)) {
            throw new InvalidUserDataException("The task name must be provided.");
        }
        Class clazz = (Class)hashMap.get("type");
        Boolean bl = Boolean.valueOf(hashMap.get(GENERATE_SUBCLASS).toString());
        TaskInternal taskInternal = this.createTaskObject(projectInternal, clazz, string, bl);
        Object v4 = hashMap.get("dependsOn");
        if (v4 != null) {
            taskInternal.dependsOn(v4);
        }
        if ((v3 = hashMap.get("description")) != null) {
            taskInternal.setDescription(v3.toString());
        }
        if ((v2 = hashMap.get("group")) != null) {
            taskInternal.setGroup(v2.toString());
        }
        if ((v = hashMap.get("action")) instanceof Action) {
            Action action = (Action)v;
            taskInternal.doFirst(action);
        } else if (v != null) {
            Closure closure = (Closure)v;
            taskInternal.doFirst(closure);
        }
        return taskInternal;
    }

    private TaskInternal createTaskObject(ProjectInternal projectInternal, final Class<? extends TaskInternal> clazz, String string, boolean bl) {
        Object[] objectArray;
        Constructor<? extends TaskInternal> constructor;
        if (!Task.class.isAssignableFrom(clazz)) {
            throw new InvalidUserDataException(String.format("Cannot create task of type '%s' as it does not implement the Task interface.", clazz.getSimpleName()));
        }
        Class<? extends TaskInternal> clazz2 = bl ? this.generator.generate(clazz) : clazz;
        try {
            constructor = clazz2.getDeclaredConstructor(new Class[0]);
            objectArray = new Object[]{};
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvalidUserDataException(String.format("Cannot create task of type '%s' as it does not have a public no-args constructor.", clazz.getSimpleName()));
        }
        return AbstractTask.injectIntoNewInstance(projectInternal, string, new Callable<TaskInternal>(){

            @Override
            public TaskInternal call() throws Exception {
                try {
                    return (TaskInternal)constructor.newInstance(objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new TaskInstantiationException(String.format("Could not create task of type '%s'.", clazz.getSimpleName()), invocationTargetException.getCause());
                }
                catch (Exception exception) {
                    throw new TaskInstantiationException(String.format("Could not create task of type '%s'.", clazz.getSimpleName()), exception);
                }
            }
        });
    }

    private void checkTaskArgsAndCreateDefaultValues(Map<String, Object> map) {
        this.setIfNull(map, "name", "");
        this.setIfNull(map, "type", DefaultTask.class);
        if (((Class)map.get("type")).isAssignableFrom(DefaultTask.class)) {
            map.put("type", DefaultTask.class);
        }
        this.setIfNull(map, GENERATE_SUBCLASS, "true");
    }

    private void setIfNull(Map<String, Object> map, String string, Object object) {
        if (map.get(string) == null) {
            map.put(string, object);
        }
    }
}

