/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.project.taskfactory.PropertyActionContext;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.internal.UncheckedException;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilePropertyAnnotationHandler
implements PropertyAnnotationHandler {
    private final Class<? extends Annotation> annotationType;
    private final Transformer<Iterable<File>, Object> valueTransformer;
    private final ValidationAction outputDirValidation = new ValidationAction(){

        @Override
        public void validate(String string, Object object, Collection<String> collection) {
            block0: for (File file : (Iterable)OutputFilePropertyAnnotationHandler.this.valueTransformer.transform(object)) {
                if (file.exists() && file.isDirectory()) {
                    collection.add(String.format("Cannot write to file '%s' specified for property '%s' as it is a directory.", file, string));
                }
                for (File file2 = file.getParentFile(); file2 != null && !file2.isDirectory(); file2 = file2.getParentFile()) {
                    if (!file2.exists() || file2.isDirectory()) continue;
                    collection.add(String.format("Cannot write to file '%s' specified for property '%s', as ancestor '%s' is not a directory.", file, string, file2));
                    continue block0;
                }
            }
        }
    };

    public OutputFilePropertyAnnotationHandler(Class<? extends Annotation> clazz, Transformer<Iterable<File>, Object> transformer) {
        this.annotationType = clazz;
        this.valueTransformer = transformer;
    }

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    @Override
    public void attachActions(final PropertyActionContext propertyActionContext) {
        propertyActionContext.setValidationAction(this.outputDirValidation);
        propertyActionContext.setConfigureAction(new UpdateAction(){

            @Override
            public void update(Task task, final Callable<Object> callable) {
                task.getOutputs().files(callable);
                task.doFirst((Action<? super Task>)new Action<Task>(){

                    @Override
                    public void execute(Task task) {
                        Iterable iterable;
                        try {
                            iterable = (Iterable)OutputFilePropertyAnnotationHandler.this.valueTransformer.transform(callable.call());
                        }
                        catch (Exception exception) {
                            throw UncheckedException.throwAsUncheckedException((Throwable)exception);
                        }
                        for (File file : iterable) {
                            if ((file = GFileUtils.canonicalise(file)).getParentFile().isDirectory() || file.getParentFile().mkdirs()) continue;
                            throw new InvalidUserDataException(String.format("Cannot create parent directory '%s' of file specified for property '%s'.", file.getParentFile(), propertyActionContext.getName()));
                        }
                    }
                });
            }
        });
    }
}

