/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.internal.project.taskfactory.PropertyActionContext;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.tasks.InputFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputFilePropertyAnnotationHandler
implements PropertyAnnotationHandler {
    private final ValidationAction inputFileValidation = new ValidationAction(){

        @Override
        public void validate(String string, Object object, Collection<String> collection) {
            File file = (File)object;
            if (!file.exists()) {
                collection.add(String.format("File '%s' specified for property '%s' does not exist.", file, string));
            } else if (!file.isFile()) {
                collection.add(String.format("File '%s' specified for property '%s' is not a file.", file, string));
            }
        }
    };

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return InputFile.class;
    }

    @Override
    public void attachActions(PropertyActionContext propertyActionContext) {
        propertyActionContext.setValidationAction(this.inputFileValidation);
        propertyActionContext.setConfigureAction(new UpdateAction(){

            @Override
            public void update(Task task, Callable<Object> callable) {
                task.getInputs().files(callable);
            }
        });
    }
}

