/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.internal.project.taskfactory.PropertyActionContext;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputDirectoryPropertyAnnotationHandler
implements PropertyAnnotationHandler {
    private final ValidationAction inputDirValidation = new ValidationAction(){

        @Override
        public void validate(String string, Object object, Collection<String> collection) {
            File file;
            File file2 = file = object instanceof ConfigurableFileTree ? ((ConfigurableFileTree)object).getDir() : (File)object;
            if (!file.exists()) {
                collection.add(String.format("Directory '%s' specified for property '%s' does not exist.", file, string));
            } else if (!file.isDirectory()) {
                collection.add(String.format("Directory '%s' specified for property '%s' is not a directory.", file, string));
            }
        }
    };

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return InputDirectory.class;
    }

    @Override
    public void attachActions(PropertyActionContext propertyActionContext) {
        propertyActionContext.setValidationAction(this.inputDirValidation);
        final boolean bl = propertyActionContext.getTarget().getAnnotation(SkipWhenEmpty.class) != null;
        propertyActionContext.setConfigureAction(new UpdateAction(){

            @Override
            public void update(Task task, Callable<Object> callable) {
                if (bl) {
                    task.getInputs().sourceDir(callable);
                } else {
                    task.getInputs().dir(callable);
                }
            }
        });
    }
}

