/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.project.taskfactory.InputDirectoryPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputFilePropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputFilesPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.NestedBeanPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputDirectoryPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputFilePropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.PropertyActionContext;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.internal.tasks.execution.TaskValidator;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessingTaskFactory
implements ITaskFactory {
    private final ITaskFactory taskFactory;
    private final Map<Class, List<Action<Task>>> actionsForType = new HashMap<Class, List<Action<Task>>>();
    private final Transformer<Iterable<File>, Object> filePropertyTransformer = new Transformer<Iterable<File>, Object>(){

        @Override
        public Iterable<File> transform(Object object) {
            File file = (File)object;
            return file == null ? Collections.emptyList() : Collections.singleton(file);
        }
    };
    private final Transformer<Iterable<File>, Object> iterableFilePropertyTransformer = new Transformer<Iterable<File>, Object>(){

        @Override
        public Iterable<File> transform(Object object) {
            return object != null ? (Iterable)object : Collections.emptyList();
        }
    };
    private final List<? extends PropertyAnnotationHandler> handlers = Arrays.asList(new InputFilePropertyAnnotationHandler(), new InputDirectoryPropertyAnnotationHandler(), new InputFilesPropertyAnnotationHandler(), new OutputFilePropertyAnnotationHandler(OutputFile.class, this.filePropertyTransformer), new OutputFilePropertyAnnotationHandler(OutputFiles.class, this.iterableFilePropertyTransformer), new OutputDirectoryPropertyAnnotationHandler(OutputDirectory.class, this.filePropertyTransformer), new OutputDirectoryPropertyAnnotationHandler(OutputDirectories.class, this.iterableFilePropertyTransformer), new InputPropertyAnnotationHandler(), new NestedBeanPropertyAnnotationHandler());
    private final ValidationAction notNullValidator = new ValidationAction(){

        @Override
        public void validate(String string, Object object, Collection<String> collection) {
            if (object == null) {
                collection.add(String.format("No value has been specified for property '%s'.", string));
            }
        }
    };

    public AnnotationProcessingTaskFactory(ITaskFactory iTaskFactory) {
        this.taskFactory = iTaskFactory;
    }

    @Override
    public TaskInternal createTask(ProjectInternal projectInternal, Map<String, ?> map) {
        TaskInternal taskInternal = this.taskFactory.createTask(projectInternal, map);
        Class<?> clazz = taskInternal.getClass();
        List<Action<Task>> list = this.actionsForType.get(clazz);
        if (list == null) {
            list = this.createActionsForType(clazz);
            this.actionsForType.put(clazz, list);
        }
        for (Action<Task> action : list) {
            taskInternal.doFirst(action);
            if (!(action instanceof Validator)) continue;
            Validator validator = (Validator)action;
            validator.addInputsAndOutputs(taskInternal);
        }
        return taskInternal;
    }

    private List<Action<Task>> createActionsForType(Class<? extends Task> clazz) {
        ArrayList<Action<Task>> arrayList = new ArrayList<Action<Task>>();
        this.findTaskActions(clazz, arrayList);
        this.findProperties(clazz, arrayList);
        return arrayList;
    }

    private void findProperties(Class<? extends Task> clazz, List<Action<Task>> list) {
        Validator validator = new Validator();
        validator.attachActions(null, clazz);
        if (!validator.properties.isEmpty()) {
            list.add(validator);
        }
    }

    private void findTaskActions(Class<? extends Task> clazz, List<Action<Task>> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Class<? extends Task> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            for (Method method : clazz2.getDeclaredMethods()) {
                this.attachTaskAction(method, list, hashSet);
            }
        }
    }

    private void attachTaskAction(final Method method, Collection<Action<Task>> collection, Collection<String> collection2) {
        if (method.getAnnotation(TaskAction.class) == null) {
            return;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new GradleException(String.format("Cannot use @TaskAction annotation on static method %s.%s().", method.getDeclaringClass().getSimpleName(), method.getName()));
        }
        if (method.getParameterTypes().length > 0) {
            throw new GradleException(String.format("Cannot use @TaskAction annotation on method %s.%s() as this method takes parameters.", method.getDeclaringClass().getSimpleName(), method.getName()));
        }
        if (collection2.contains(method.getName())) {
            return;
        }
        collection2.add(method.getName());
        collection.add(new Action<Task>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(Task task) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(method.getDeclaringClass().getClassLoader());
                try {
                    ReflectionUtil.invoke(task, method.getName(), new Object[0]);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
            }
        });
    }

    private static boolean isGetter(Method method) {
        return method.getName().startsWith("get") && method.getReturnType() != Void.TYPE && method.getParameterTypes().length == 0 && !Modifier.isStatic(method.getModifiers());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyInfo
    implements PropertyActionContext {
        private static final ValidationAction NO_OP_VALIDATION_ACTION = new ValidationAction(){

            @Override
            public void validate(String string, Object object, Collection<String> collection) {
            }
        };
        private static final PropertyValue NO_OP_VALUE = new PropertyValue(){

            @Override
            public Object getValue() {
                return null;
            }

            @Override
            public void checkNotNull(Collection<String> collection) {
            }

            @Override
            public void checkValid(Collection<String> collection) {
            }
        };
        private static final UpdateAction NO_OP_CONFIGURATION_ACTION = new UpdateAction(){

            @Override
            public void update(Task task, Callable<Object> callable) {
            }
        };
        private final Validator validator;
        private final PropertyInfo parent;
        private final String propertyName;
        private final Method method;
        private ValidationAction validationAction = NO_OP_VALIDATION_ACTION;
        private ValidationAction notNullValidator = NO_OP_VALIDATION_ACTION;
        private UpdateAction configureAction = NO_OP_CONFIGURATION_ACTION;
        public boolean required;
        private final Class<?> type;

        private PropertyInfo(Class<?> clazz, Validator validator, PropertyInfo propertyInfo, String string, Method method) {
            this.type = clazz;
            this.validator = validator;
            this.parent = propertyInfo;
            this.propertyName = string;
            this.method = method;
        }

        public String toString() {
            return this.propertyName;
        }

        @Override
        public String getName() {
            return this.propertyName;
        }

        @Override
        public Class<?> getType() {
            return this.method.getReturnType();
        }

        @Override
        public Class<?> getInstanceVariableType() {
            Class<?> clazz = this.type;
            while (!clazz.equals(Object.class)) {
                try {
                    return clazz.getDeclaredField(this.propertyName).getType();
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    clazz = clazz.getSuperclass();
                }
            }
            return null;
        }

        @Override
        public AnnotatedElement getTarget() {
            return this.method;
        }

        @Override
        public void setValidationAction(ValidationAction validationAction) {
            this.validationAction = validationAction;
        }

        @Override
        public void setConfigureAction(UpdateAction updateAction) {
            this.configureAction = updateAction;
        }

        public void setNotNullValidator(ValidationAction validationAction) {
            this.notNullValidator = validationAction;
        }

        @Override
        public void attachActions(Class<?> clazz) {
            this.validator.attachActions(this, clazz);
        }

        public PropertyValue getValue(Object object) {
            Object object2;
            Object object3 = object;
            if (this.parent != null) {
                object2 = this.parent.getValue(object);
                if (object2.getValue() == null) {
                    return NO_OP_VALUE;
                }
                object3 = object2.getValue();
            }
            object2 = ReflectionUtil.invoke(object3, this.method.getName(), new Object[0]);
            return new PropertyValue(){

                @Override
                public Object getValue() {
                    return object2;
                }

                @Override
                public void checkNotNull(Collection<String> collection) {
                    PropertyInfo.this.notNullValidator.validate(PropertyInfo.this.propertyName, object2, collection);
                }

                @Override
                public void checkValid(Collection<String> collection) {
                    if (object2 != null) {
                        PropertyInfo.this.validationAction.validate(PropertyInfo.this.propertyName, object2, collection);
                    }
                }
            };
        }

        public void attachActions(PropertyAnnotationHandler propertyAnnotationHandler) {
            propertyAnnotationHandler.attachActions(this);
            this.required = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface PropertyValue {
        public Object getValue();

        public void checkNotNull(Collection<String> var1);

        public void checkValid(Collection<String> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Validator
    implements Action<Task>,
    TaskValidator {
        private Set<PropertyInfo> properties = new LinkedHashSet<PropertyInfo>();

        private Validator() {
        }

        public void addInputsAndOutputs(final TaskInternal taskInternal) {
            taskInternal.addValidator(this);
            for (final PropertyInfo propertyInfo : this.properties) {
                Callable<Object> callable = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return propertyInfo.getValue(taskInternal).getValue();
                    }
                };
                propertyInfo.configureAction.update(taskInternal, callable);
            }
        }

        @Override
        public void execute(Task task) {
        }

        @Override
        public void validate(TaskInternal taskInternal, Collection<String> collection) {
            ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
            for (PropertyInfo object : this.properties) {
                arrayList.add(object.getValue(taskInternal));
            }
            for (PropertyValue propertyValue : arrayList) {
                propertyValue.checkNotNull(collection);
            }
            for (PropertyValue propertyValue : arrayList) {
                propertyValue.checkValid(collection);
            }
        }

        public void attachActions(PropertyInfo propertyInfo, Class<?> clazz) {
            if (clazz.getSuperclass() != null) {
                this.attachActions(propertyInfo, clazz.getSuperclass());
            }
            for (Method method : clazz.getDeclaredMethods()) {
                String string;
                if (!AnnotationProcessingTaskFactory.isGetter(method)) continue;
                String string2 = string = StringUtils.uncapitalize((String)method.getName().substring(3));
                if (propertyInfo != null) {
                    string2 = propertyInfo.getName() + '.' + string2;
                }
                PropertyInfo propertyInfo2 = new PropertyInfo(clazz, this, propertyInfo, string2, method);
                this.attachValidationActions(propertyInfo2, string);
                if (!propertyInfo2.required) continue;
                this.properties.add(propertyInfo2);
            }
        }

        private void attachValidationActions(PropertyInfo propertyInfo, String string) {
            for (PropertyAnnotationHandler propertyAnnotationHandler : AnnotationProcessingTaskFactory.this.handlers) {
                this.attachValidationAction(propertyAnnotationHandler, propertyInfo, string);
            }
        }

        private void attachValidationAction(PropertyAnnotationHandler propertyAnnotationHandler, PropertyInfo propertyInfo, String string) {
            Object object;
            Method method = propertyInfo.method;
            Class<? extends Annotation> clazz = propertyAnnotationHandler.getAnnotationType();
            Object object2 = null;
            if (method.getAnnotation(clazz) != null) {
                object2 = method;
            } else {
                try {
                    object = method.getDeclaringClass().getDeclaredField(string);
                    if (((Field)object).getAnnotation(clazz) != null) {
                        object2 = object;
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            if (object2 == null) {
                return;
            }
            object = object2.getAnnotation(Optional.class);
            if (object == null) {
                propertyInfo.setNotNullValidator(AnnotationProcessingTaskFactory.this.notNullValidator);
            }
            propertyInfo.attachActions(propertyAnnotationHandler);
        }
    }
}

