/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import org.gradle.StartParameter;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.internal.changedetection.CacheBackedFileSnapshotRepository;
import org.gradle.api.internal.changedetection.CacheBackedTaskHistoryRepository;
import org.gradle.api.internal.changedetection.CacheLockHandlingTaskExecuter;
import org.gradle.api.internal.changedetection.CachingHasher;
import org.gradle.api.internal.changedetection.DefaultFileCacheListener;
import org.gradle.api.internal.changedetection.DefaultFileSnapshotter;
import org.gradle.api.internal.changedetection.DefaultHasher;
import org.gradle.api.internal.changedetection.DefaultTaskArtifactStateCacheAccess;
import org.gradle.api.internal.changedetection.DefaultTaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.FileCacheBroadcastTaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.OutputFilesSnapshotter;
import org.gradle.api.internal.changedetection.ShortCircuitTaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.TaskArtifactStateCacheAccess;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.execution.ExecuteActionsTaskExecuter;
import org.gradle.api.internal.tasks.execution.ExecuteAtMostOnceTaskExecuter;
import org.gradle.api.internal.tasks.execution.PostExecutionAnalysisTaskExecuter;
import org.gradle.api.internal.tasks.execution.SkipEmptySourceFilesTaskExecuter;
import org.gradle.api.internal.tasks.execution.SkipOnlyIfTaskExecuter;
import org.gradle.api.internal.tasks.execution.SkipTaskWithNoActionsExecuter;
import org.gradle.api.internal.tasks.execution.SkipUpToDateTaskExecuter;
import org.gradle.api.internal.tasks.execution.ValidatingTaskExecuter;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheRepository;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.listener.ListenerManager;
import org.gradle.util.RandomLongIdGenerator;

public class TaskExecutionServices
extends DefaultServiceRegistry {
    private final Gradle gradle;

    public TaskExecutionServices(ServiceRegistry serviceRegistry, Gradle gradle) {
        super(serviceRegistry);
        this.gradle = gradle;
    }

    protected TaskExecuter createTaskExecuter() {
        return new ExecuteAtMostOnceTaskExecuter(new SkipOnlyIfTaskExecuter(new SkipTaskWithNoActionsExecuter(new SkipEmptySourceFilesTaskExecuter(new ValidatingTaskExecuter(new SkipUpToDateTaskExecuter(new CacheLockHandlingTaskExecuter(new PostExecutionAnalysisTaskExecuter(new ExecuteActionsTaskExecuter(((ListenerManager)this.get(ListenerManager.class)).getBroadcaster(TaskActionListener.class))), (TaskArtifactStateCacheAccess)this.get(TaskArtifactStateCacheAccess.class)), (TaskArtifactStateRepository)this.get(TaskArtifactStateRepository.class)))))));
    }

    protected TaskArtifactStateCacheAccess createCacheAccess() {
        return new DefaultTaskArtifactStateCacheAccess(this.gradle, (CacheRepository)this.get(CacheRepository.class));
    }

    protected TaskArtifactStateRepository createTaskArtifactStateRepository() {
        TaskArtifactStateCacheAccess taskArtifactStateCacheAccess = (TaskArtifactStateCacheAccess)this.get(TaskArtifactStateCacheAccess.class);
        DefaultFileSnapshotter defaultFileSnapshotter = new DefaultFileSnapshotter(new CachingHasher(new DefaultHasher(), taskArtifactStateCacheAccess));
        OutputFilesSnapshotter outputFilesSnapshotter = new OutputFilesSnapshotter(defaultFileSnapshotter, new RandomLongIdGenerator(), taskArtifactStateCacheAccess);
        CacheBackedTaskHistoryRepository cacheBackedTaskHistoryRepository = new CacheBackedTaskHistoryRepository(taskArtifactStateCacheAccess, new CacheBackedFileSnapshotRepository(taskArtifactStateCacheAccess));
        return new FileCacheBroadcastTaskArtifactStateRepository(new ShortCircuitTaskArtifactStateRepository((StartParameter)this.get(StartParameter.class), new DefaultTaskArtifactStateRepository(cacheBackedTaskHistoryRepository, defaultFileSnapshotter, outputFilesSnapshotter)), new DefaultFileCacheListener());
    }
}

