/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.io.File;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.Instantiator;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.StringScriptSource;
import org.gradle.groovy.scripts.UriScriptSource;

public class ProjectFactory
implements IProjectFactory {
    private final Instantiator instantiator;

    public ProjectFactory(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public DefaultProject createProject(ProjectDescriptor projectDescriptor, ProjectInternal projectInternal, GradleInternal gradleInternal) {
        File file = projectDescriptor.getBuildFile();
        ScriptSource scriptSource = !file.exists() ? new StringScriptSource("empty build file", "") : new UriScriptSource("build file", file);
        DefaultProject defaultProject = this.instantiator.newInstance(DefaultProject.class, projectDescriptor.getName(), projectInternal, projectDescriptor.getProjectDir(), scriptSource, gradleInternal, gradleInternal.getServices());
        if (projectInternal != null) {
            projectInternal.addChildProject(defaultProject);
        }
        gradleInternal.getProjectRegistry().addProject(defaultProject);
        return defaultProject;
    }
}

