/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.project.IProjectRegistry;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.specs.Spec;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectRegistry<T extends ProjectIdentifier>
implements IProjectRegistry<T> {
    private Map<String, T> projects = new HashMap<String, T>();
    private Map<String, Set<T>> subProjects = new HashMap<String, Set<T>>();

    @Override
    public void addProject(T t) {
        this.projects.put(t.getPath(), t);
        this.subProjects.put(t.getPath(), new HashSet());
        this.addProjectToParentSubProjects(t);
    }

    public T removeProject(String string) {
        ProjectIdentifier projectIdentifier = (ProjectIdentifier)this.projects.remove(string);
        assert (projectIdentifier != null);
        this.subProjects.remove(string);
        for (ProjectIdentifier projectIdentifier2 = projectIdentifier.getParentIdentifier(); projectIdentifier2 != null; projectIdentifier2 = projectIdentifier2.getParentIdentifier()) {
            this.subProjects.get(projectIdentifier2.getPath()).remove(projectIdentifier);
        }
        return (T)projectIdentifier;
    }

    private void addProjectToParentSubProjects(T t) {
        for (ProjectIdentifier projectIdentifier = t.getParentIdentifier(); projectIdentifier != null; projectIdentifier = projectIdentifier.getParentIdentifier()) {
            this.subProjects.get(projectIdentifier.getPath()).add(t);
        }
    }

    @Override
    public Set<T> getAllProjects() {
        return new HashSet<T>(this.projects.values());
    }

    @Override
    public T getProject(String string) {
        return (T)((ProjectIdentifier)this.projects.get(string));
    }

    @Override
    public T getProject(final File file) {
        Set<T> set = this.findAll(new Spec<T>(){

            @Override
            public boolean isSatisfiedBy(T t) {
                return t.getProjectDir().equals(file);
            }
        });
        if (set.size() > 1) {
            throw new InvalidUserDataException(String.format("Found multiple projects with project directory '%s': %s", file, set));
        }
        return (T)(set.size() == 1 ? (ProjectIdentifier)set.iterator().next() : null);
    }

    @Override
    public Set<T> getAllProjects(String string) {
        HashSet<T> hashSet = new HashSet<T>(this.getSubProjects(string));
        if (this.projects.get(string) != null) {
            hashSet.add(this.projects.get(string));
        }
        return hashSet;
    }

    @Override
    public Set<T> getSubProjects(String string) {
        return GUtil.elvis(this.subProjects.get(string), new HashSet());
    }

    @Override
    public Set<T> findAll(Spec<? super T> spec) {
        HashSet<ProjectIdentifier> hashSet = new HashSet<ProjectIdentifier>();
        for (ProjectIdentifier projectIdentifier : this.projects.values()) {
            if (!spec.isSatisfiedBy(projectIdentifier)) continue;
            hashSet.add(projectIdentifier);
        }
        return hashSet;
    }
}

