/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.PathValidation;
import org.gradle.api.Project;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.Task;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.Module;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.BeanDynamicObject;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.DynamicPropertyNamer;
import org.gradle.api.internal.ExtensibleDynamicObject;
import org.gradle.api.internal.FactoryNamedDomainObjectContainer;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.Instantiator;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.internal.artifacts.configurations.ConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ScriptClassLoaderProvider;
import org.gradle.api.internal.plugins.DefaultObjectConfigurationAction;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.project.IProjectRegistry;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectScript;
import org.gradle.api.internal.project.ProjectStateInternal;
import org.gradle.api.internal.project.ServiceRegistryFactory;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.LoggingManager;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.tasks.Directory;
import org.gradle.api.tasks.WorkResult;
import org.gradle.configuration.ProjectEvaluator;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.Script;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.Factory;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.StandardOutputCapture;
import org.gradle.process.ExecResult;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProject
implements ProjectInternal,
DynamicObjectAware {
    private static Logger buildLogger = Logging.getLogger(Project.class);
    private ServiceRegistryFactory services;
    private final ProjectInternal rootProject;
    private final GradleInternal gradle;
    private ProjectEvaluator projectEvaluator;
    private ScriptSource buildScriptSource;
    private final File projectDir;
    private final ProjectInternal parent;
    private final String name;
    private Object group;
    private Object version;
    private Object status;
    private final Map<String, Project> childProjects = new HashMap<String, Project>();
    private List<String> defaultTasks = new ArrayList<String>();
    private Set<Project> dependsOnProjects = new HashSet<Project>();
    private ProjectStateInternal state;
    private FileResolver fileResolver;
    private FileOperations fileOperations;
    private ProcessOperations processOperations;
    private Factory<AntBuilder> antBuilderFactory;
    private AntBuilder ant;
    private Object buildDir = "build";
    private PluginContainer pluginContainer;
    private final int depth;
    private TaskContainerInternal taskContainer;
    private TaskContainerInternal implicitTasksContainer;
    private IProjectRegistry<ProjectInternal> projectRegistry;
    private DependencyHandler dependencyHandler;
    private ConfigurationContainerInternal configurationContainer;
    private ArtifactHandler artifactHandler;
    private RepositoryHandler repositoryHandler;
    private ScriptHandler scriptHandler;
    private ScriptClassLoaderProvider scriptClassLoaderProvider;
    private ListenerBroadcast<ProjectEvaluationListener> evaluationListener = new ListenerBroadcast<ProjectEvaluationListener>(ProjectEvaluationListener.class);
    private LoggingManagerInternal loggingManager;
    private ExtensibleDynamicObject extensibleDynamicObject;
    private String description;
    private final Path path;

    public AbstractProject(String string, ProjectInternal projectInternal, File file, ScriptSource scriptSource, GradleInternal gradleInternal, ServiceRegistryFactory serviceRegistryFactory) {
        assert (string != null);
        this.rootProject = projectInternal != null ? projectInternal.getRootProject() : this;
        this.projectDir = file;
        this.parent = projectInternal;
        this.name = string;
        this.state = new ProjectStateInternal();
        this.buildScriptSource = scriptSource;
        this.gradle = gradleInternal;
        if (projectInternal == null) {
            this.path = Path.ROOT;
            this.depth = 0;
        } else {
            String string2 = projectInternal.absoluteProjectPath(string);
            this.depth = projectInternal.getDepth() + 1;
            this.path = Path.path(string2);
        }
        this.services = serviceRegistryFactory.createFor(this);
        this.fileResolver = (FileResolver)this.services.get(FileResolver.class);
        this.antBuilderFactory = this.services.getFactory(AntBuilder.class);
        this.taskContainer = (TaskContainerInternal)this.services.newInstance(TaskContainerInternal.class);
        this.implicitTasksContainer = (TaskContainerInternal)this.services.newInstance(TaskContainerInternal.class);
        this.fileOperations = (FileOperations)this.services.get(FileOperations.class);
        this.processOperations = (ProcessOperations)this.services.get(ProcessOperations.class);
        this.projectEvaluator = (ProjectEvaluator)this.services.get(ProjectEvaluator.class);
        this.repositoryHandler = (RepositoryHandler)this.services.get(RepositoryHandler.class);
        this.configurationContainer = (ConfigurationContainerInternal)this.services.get(ConfigurationContainerInternal.class);
        this.pluginContainer = (PluginContainer)this.services.get(PluginContainer.class);
        this.artifactHandler = (ArtifactHandler)this.services.get(ArtifactHandler.class);
        this.dependencyHandler = (DependencyHandler)this.services.get(DependencyHandler.class);
        this.scriptHandler = (ScriptHandler)this.services.get(ScriptHandler.class);
        this.scriptClassLoaderProvider = (ScriptClassLoaderProvider)this.services.get(ScriptClassLoaderProvider.class);
        this.projectRegistry = (IProjectRegistry)this.services.get(IProjectRegistry.class);
        this.loggingManager = (LoggingManagerInternal)this.services.get(LoggingManagerInternal.class);
        this.extensibleDynamicObject = new ExtensibleDynamicObject(this, (Instantiator)this.services.get(Instantiator.class));
        if (projectInternal != null) {
            this.extensibleDynamicObject.setParent(projectInternal.getInheritedScope());
        }
        this.extensibleDynamicObject.addObject(this.taskContainer.getTasksAsDynamicObject(), ExtensibleDynamicObject.Location.AfterConvention);
        this.evaluationListener.add(gradleInternal.getProjectEvaluationBroadcaster());
    }

    @Override
    public ProjectInternal getRootProject() {
        return this.rootProject;
    }

    @Override
    public GradleInternal getGradle() {
        return this.gradle;
    }

    @Override
    public PluginContainer getPlugins() {
        return this.pluginContainer;
    }

    public ProjectEvaluator getProjectEvaluator() {
        return this.projectEvaluator;
    }

    public void setProjectEvaluator(ProjectEvaluator projectEvaluator) {
        this.projectEvaluator = projectEvaluator;
    }

    @Override
    public ScriptHandler getBuildscript() {
        return this.scriptHandler;
    }

    @Override
    public void beforeCompile(ScriptPlugin scriptPlugin) {
        if (scriptPlugin.getSource() != this.buildScriptSource) {
            return;
        }
        scriptPlugin.setScriptBaseClass(ProjectScript.class);
        scriptPlugin.setClassLoaderProvider(this.scriptClassLoaderProvider);
    }

    @Override
    public void afterCompile(ScriptPlugin scriptPlugin, Script script) {
        if (scriptPlugin.getSource() != this.buildScriptSource) {
            return;
        }
        this.setScript(script);
    }

    @Override
    public File getBuildFile() {
        return this.getBuildscript().getSourceFile();
    }

    public void setScript(groovy.lang.Script script) {
        this.extensibleDynamicObject.addObject(new BeanDynamicObject(script).withNoProperties(), ExtensibleDynamicObject.Location.BeforeConvention);
    }

    @Override
    public ScriptSource getBuildScriptSource() {
        return this.buildScriptSource;
    }

    @Override
    public File getRootDir() {
        return this.rootProject.getProjectDir();
    }

    @Override
    public ProjectInternal getParent() {
        return this.parent;
    }

    @Override
    public ProjectIdentifier getParentIdentifier() {
        return this.parent;
    }

    @Override
    public DynamicObject getAsDynamicObject() {
        return this.extensibleDynamicObject;
    }

    @Override
    public DynamicObject getInheritedScope() {
        return this.extensibleDynamicObject.getInheritable();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public Object getGroup() {
        if (this.group != null) {
            return this.group;
        }
        if (this == this.rootProject) {
            return "";
        }
        return this.rootProject.getName() + (this.getParent() == this.rootProject ? "" : "." + this.getParent().getPath().substring(1).replace(':', '.'));
    }

    @Override
    public void setGroup(Object object) {
        this.group = object;
    }

    @Override
    public Object getVersion() {
        return this.version == null ? "unspecified" : this.version;
    }

    @Override
    public void setVersion(Object object) {
        this.version = object;
    }

    @Override
    public Object getStatus() {
        return this.status == null ? "release" : this.status;
    }

    @Override
    public void setStatus(Object object) {
        this.status = object;
    }

    @Override
    public Map<String, Project> getChildProjects() {
        return this.childProjects;
    }

    @Override
    public List<String> getDefaultTasks() {
        return this.defaultTasks;
    }

    @Override
    public void setDefaultTasks(List<String> list) {
        this.defaultTasks = list;
    }

    @Override
    public Set<Project> getDependsOnProjects() {
        return this.dependsOnProjects;
    }

    @Override
    public ProjectStateInternal getState() {
        return this.state;
    }

    @Override
    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public void setAnt(AntBuilder antBuilder) {
        this.ant = antBuilder;
    }

    @Override
    public ArtifactHandler getArtifacts() {
        return this.artifactHandler;
    }

    public void setArtifactHandler(ArtifactHandler artifactHandler) {
        this.artifactHandler = artifactHandler;
    }

    @Override
    public RepositoryHandler getRepositories() {
        return this.repositoryHandler;
    }

    @Override
    public ConfigurationContainerInternal getConfigurations() {
        return this.configurationContainer;
    }

    public void setConfigurationContainer(ConfigurationContainerInternal configurationContainerInternal) {
        this.configurationContainer = configurationContainerInternal;
    }

    @Override
    public Convention getConvention() {
        return this.extensibleDynamicObject.getConvention();
    }

    @Override
    public String getPath() {
        return this.path.toString();
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public IProjectRegistry<ProjectInternal> getProjectRegistry() {
        return this.projectRegistry;
    }

    @Override
    public int depthCompare(Project project) {
        return new Integer(this.getDepth()).compareTo(project.getDepth());
    }

    @Override
    public int compareTo(Project project) {
        int n = this.depthCompare(project);
        if (n == 0) {
            return this.getPath().compareTo(project.getPath());
        }
        return n;
    }

    @Override
    public String absoluteProjectPath(String string) {
        return this.path.absolutePath(string);
    }

    @Override
    public String relativeProjectPath(String string) {
        return this.path.relativePath(string);
    }

    @Override
    public ProjectInternal project(String string) {
        ProjectInternal projectInternal = this.findProject(string);
        if (projectInternal == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found in %s.", string, this));
        }
        return projectInternal;
    }

    @Override
    public ProjectInternal findProject(String string) {
        if (!GUtil.isTrue(string)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        return this.projectRegistry.getProject(this.absoluteProjectPath(string));
    }

    @Override
    public Set<Project> getAllprojects() {
        return new TreeSet<Project>(this.projectRegistry.getAllProjects(this.getPath()));
    }

    @Override
    public Set<Project> getSubprojects() {
        return new TreeSet<Project>(this.projectRegistry.getSubProjects(this.getPath()));
    }

    @Override
    public void subprojects(Action<? super Project> action) {
        this.configure(this.getSubprojects(), action);
    }

    @Override
    public void allprojects(Action<? super Project> action) {
        this.configure(this.getAllprojects(), action);
    }

    @Override
    public <T> Iterable<T> configure(Iterable<T> iterable, Action<? super T> action) {
        for (T t : iterable) {
            action.execute(t);
        }
        return iterable;
    }

    @Override
    public AntBuilder getAnt() {
        if (this.ant == null) {
            this.ant = this.createAntBuilder();
        }
        return this.ant;
    }

    @Override
    public AntBuilder createAntBuilder() {
        return (AntBuilder)((Object)this.antBuilderFactory.create());
    }

    @Override
    public Project getProject() {
        return this;
    }

    @Override
    public AbstractProject evaluate() {
        this.projectEvaluator.evaluate(this, this.state);
        this.state.rethrowFailure();
        return this;
    }

    @Override
    public TaskContainerInternal getTasks() {
        return this.taskContainer;
    }

    @Override
    public TaskContainerInternal getImplicitTasks() {
        return this.implicitTasksContainer;
    }

    @Override
    public void defaultTasks(String ... stringArray) {
        if (stringArray == null) {
            throw new InvalidUserDataException("Default tasks must not be null!");
        }
        this.defaultTasks = new ArrayList<String>();
        for (String string : stringArray) {
            if (string == null) {
                throw new InvalidUserDataException("Default tasks must not be null!");
            }
            this.defaultTasks.add(string);
        }
    }

    public Task createTask(Map map, String string, Closure closure) {
        this.warnCreateTaskDeprecated();
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        hashMap.put("name", string);
        hashMap.put("action", (String)closure);
        return this.taskContainer.add((Map<String, ?>)hashMap);
    }

    public Task createTask(Map<String, ?> map, String string, Action<? super Task> action) {
        this.warnCreateTaskDeprecated();
        HashMap hashMap = new HashMap(map);
        hashMap.put("name", string);
        if (action != null) {
            hashMap.put("action", action);
        }
        return this.taskContainer.add(hashMap);
    }

    private void warnCreateTaskDeprecated() {
        DeprecationLogger.nagUserOfReplacedMethod("Project.createTask()", "task()");
    }

    @Override
    public void addChildProject(ProjectInternal projectInternal) {
        this.childProjects.put(projectInternal.getName(), projectInternal);
    }

    @Override
    public File getProjectDir() {
        return this.projectDir;
    }

    @Override
    public File getBuildDir() {
        return this.file(this.buildDir);
    }

    @Override
    public void setBuildDir(Object object) {
        this.buildDir = object;
    }

    @Override
    public void dependsOn(final String string) {
        DeprecationLogger.nagUserOfDiscontinuedMethod("Project.dependsOn(String path)");
        DeprecationLogger.whileDisabled(new Factory<Void>(){

            public Void create() {
                AbstractProject.this.dependsOn(string, true);
                return null;
            }
        });
    }

    @Override
    public void dependsOn(String string, boolean bl) {
        if (!GUtil.isTrue(string)) {
            throw new InvalidUserDataException("You must specify a project!");
        }
        this.dependsOnProjects.add(this.project(string));
        if (bl) {
            this.evaluationDependsOn(string);
        }
    }

    @Override
    public void evaluationDependsOnChildren() {
        for (Project project : this.childProjects.values()) {
            DefaultProject defaultProject = (DefaultProject)project;
            this.evaluationDependsOn(defaultProject);
        }
    }

    @Override
    public Project evaluationDependsOn(String string) {
        if (!GUtil.isTrue(string)) {
            throw new InvalidUserDataException("You must specify a project!");
        }
        DefaultProject defaultProject = (DefaultProject)this.project(string);
        return this.evaluationDependsOn(defaultProject);
    }

    private Project evaluationDependsOn(DefaultProject defaultProject) {
        if (defaultProject.getState().getExecuting()) {
            throw new CircularReferenceException(String.format("Circular referencing during evaluation for %s.", defaultProject));
        }
        return defaultProject.evaluate();
    }

    @Override
    public Project childrenDependOnMe() {
        DeprecationLogger.nagUserOfDiscontinuedMethod("Project.childrenDependOnMe()");
        DeprecationLogger.whileDisabled(new Factory<Void>(){

            public Void create() {
                for (Project project : AbstractProject.this.childProjects.values()) {
                    project.dependsOn(AbstractProject.this.getPath(), false);
                }
                return null;
            }
        });
        return this;
    }

    @Override
    public Project dependsOnChildren() {
        DeprecationLogger.nagUserOfDiscontinuedMethod("Project.dependsOnChildren()");
        return DeprecationLogger.whileDisabled(new Factory<Project>(){

            public Project create() {
                return AbstractProject.this.dependsOnChildren(false);
            }
        });
    }

    @Override
    public Project dependsOnChildren(final boolean bl) {
        DeprecationLogger.nagUserOfDiscontinuedMethod("Project.dependsOnChildren(boolean)");
        DeprecationLogger.whileDisabled(new Factory<Void>(){

            public Void create() {
                for (Project project : AbstractProject.this.childProjects.values()) {
                    AbstractProject.this.dependsOn(project.getPath(), bl);
                }
                return null;
            }
        });
        return this;
    }

    public String toString() {
        if (this.parent != null) {
            return String.format("project '%s'", this.path);
        }
        return String.format("root project '%s'", this.name);
    }

    @Override
    public Map<Project, Set<Task>> getAllTasks(boolean bl) {
        final TreeMap<Project, Set<Task>> treeMap = new TreeMap<Project, Set<Task>>();
        Action<Project> action = new Action<Project>(){

            @Override
            public void execute(Project project) {
                treeMap.put(project, new TreeSet<Task>(project.getTasks()));
            }
        };
        if (bl) {
            this.allprojects((Action<? super Project>)action);
        } else {
            action.execute(this);
        }
        return treeMap;
    }

    @Override
    public Set<Task> getTasksByName(final String string, boolean bl) {
        if (!GUtil.isTrue(string)) {
            throw new InvalidUserDataException("Name is not specified!");
        }
        final HashSet<Task> hashSet = new HashSet<Task>();
        Action<Project> action = new Action<Project>(){

            @Override
            public void execute(Project project) {
                Task task = (Task)project.getTasks().findByName(string);
                if (task != null) {
                    hashSet.add(task);
                }
            }
        };
        if (bl) {
            this.allprojects((Action<? super Project>)action);
        } else {
            action.execute(this);
        }
        return hashSet;
    }

    @Override
    public File file(Object object) {
        return this.fileOperations.file(object);
    }

    @Override
    public File file(Object object, PathValidation pathValidation) {
        return this.fileOperations.file(object, pathValidation);
    }

    @Override
    public URI uri(Object object) {
        return this.fileOperations.uri(object);
    }

    @Override
    public ConfigurableFileCollection files(Object ... objectArray) {
        return this.fileOperations.files(objectArray);
    }

    @Override
    public ConfigurableFileCollection files(Object object, Closure closure) {
        return this.fileOperations.files(object, closure);
    }

    @Override
    public ConfigurableFileTree fileTree(Object object) {
        return this.fileOperations.fileTree(object);
    }

    @Override
    public ConfigurableFileTree fileTree(Object object, Closure closure) {
        return this.fileOperations.fileTree(object, closure);
    }

    @Override
    public ConfigurableFileTree fileTree(Map<String, ?> map) {
        return this.fileOperations.fileTree(map);
    }

    @Override
    public ConfigurableFileTree fileTree(Closure closure) {
        DeprecationLogger.nagUserWith("fileTree(Closure) is a deprecated method. Use fileTree((Object){ baseDir }) to have the closure used as the file tree base directory");
        return this.fileOperations.fileTree(closure);
    }

    @Override
    public FileTree zipTree(Object object) {
        return this.fileOperations.zipTree(object);
    }

    @Override
    public FileTree tarTree(Object object) {
        return this.fileOperations.tarTree(object);
    }

    @Override
    public ResourceHandler getResources() {
        return this.fileOperations.getResources();
    }

    @Override
    public String relativePath(Object object) {
        return this.fileOperations.relativePath(object);
    }

    @Override
    public File mkdir(Object object) {
        return this.fileOperations.mkdir(object);
    }

    @Override
    public boolean delete(Object ... objectArray) {
        return this.fileOperations.delete(objectArray);
    }

    @Deprecated
    public Directory dir(String string) {
        DeprecationLogger.nagUserOfReplacedMethod("AbstractProject.dir()", "mkdir()");
        String[] stringArray = string.split("/");
        String string2 = "";
        Directory directory = null;
        for (String string3 : stringArray) {
            Task task = (Task)this.taskContainer.findByName(string2 = string2 + (string2.length() != 0 ? "/" + string3 : string3));
            if (task instanceof Directory) {
                directory = (Directory)task;
                continue;
            }
            if (task != null) {
                throw new InvalidUserDataException(String.format("Cannot add directory task '%s' as a non-directory task with this name already exists.", string2));
            }
            directory = this.taskContainer.add(string2, Directory.class);
        }
        return directory;
    }

    public void setTaskContainer(TaskContainerInternal taskContainerInternal) {
        this.taskContainer = taskContainerInternal;
    }

    public Factory<AntBuilder> getAntBuilderFactory() {
        return this.antBuilderFactory;
    }

    public void setAntBuilderFactory(Factory<AntBuilder> factory) {
        this.antBuilderFactory = factory;
    }

    @Override
    public DependencyHandler getDependencies() {
        return this.dependencyHandler;
    }

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    @Override
    public ProjectEvaluationListener getProjectEvaluationBroadcaster() {
        return this.evaluationListener.getSource();
    }

    @Override
    public void beforeEvaluate(Action<? super Project> action) {
        this.evaluationListener.add("beforeEvaluate", action);
    }

    @Override
    public void afterEvaluate(Action<? super Project> action) {
        this.evaluationListener.add("afterEvaluate", action);
    }

    @Override
    public void beforeEvaluate(Closure closure) {
        this.evaluationListener.add("beforeEvaluate", closure);
    }

    @Override
    public void afterEvaluate(Closure closure) {
        this.evaluationListener.add("afterEvaluate", closure);
    }

    @Override
    public Logger getLogger() {
        return buildLogger;
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.loggingManager;
    }

    @Override
    public LoggingManager getLogging() {
        return this.loggingManager;
    }

    @Override
    public Object property(String string) throws MissingPropertyException {
        return this.extensibleDynamicObject.getProperty(string);
    }

    @Override
    public void setProperty(String string, Object object) {
        this.extensibleDynamicObject.setProperty(string, object);
    }

    @Override
    public boolean hasProperty(String string) {
        return this.extensibleDynamicObject.hasProperty(string);
    }

    @Override
    public Map<String, ?> getProperties() {
        return (Map)DeprecationLogger.whileDisabled(new Factory<Map<String, ?>>(){

            public Map<String, ?> create() {
                return AbstractProject.this.extensibleDynamicObject.getProperties();
            }
        });
    }

    @Override
    public WorkResult copy(Closure closure) {
        return this.fileOperations.copy(closure);
    }

    @Override
    public CopySpec copySpec(Closure closure) {
        return this.fileOperations.copySpec(closure);
    }

    @Override
    public ExecResult javaexec(Closure closure) {
        return this.processOperations.javaexec(closure);
    }

    @Override
    public ExecResult exec(Closure closure) {
        return this.processOperations.exec(closure);
    }

    @Override
    public ServiceRegistryFactory getServices() {
        return this.services;
    }

    @Override
    public Module getModule() {
        return ((DependencyMetaDataProvider)this.getServices().get(DependencyMetaDataProvider.class)).getModule();
    }

    @Override
    public void apply(Closure closure) {
        DefaultObjectConfigurationAction defaultObjectConfigurationAction = new DefaultObjectConfigurationAction(this.fileResolver, (ScriptPluginFactory)this.services.get(ScriptPluginFactory.class), this);
        this.configure(defaultObjectConfigurationAction, closure);
        defaultObjectConfigurationAction.execute();
    }

    @Override
    public void apply(Map<String, ?> map) {
        DefaultObjectConfigurationAction defaultObjectConfigurationAction = new DefaultObjectConfigurationAction(this.fileResolver, (ScriptPluginFactory)this.services.get(ScriptPluginFactory.class), this);
        ConfigureUtil.configureByMap(map, defaultObjectConfigurationAction);
        defaultObjectConfigurationAction.execute();
    }

    @Override
    public AntBuilder ant(Closure closure) {
        return ConfigureUtil.configure(closure, this.getAnt());
    }

    @Override
    public void subprojects(Closure closure) {
        this.configure(this.getSubprojects(), closure);
    }

    @Override
    public void allprojects(Closure closure) {
        this.configure(this.getAllprojects(), closure);
    }

    @Override
    public Project project(String string, Closure closure) {
        return ConfigureUtil.configure(closure, this.project(string));
    }

    @Override
    public Object configure(Object object, Closure closure) {
        return ConfigureUtil.configure(closure, object);
    }

    @Override
    public Iterable<?> configure(Iterable<?> iterable, Closure closure) {
        for (Object obj : iterable) {
            this.configure(obj, closure);
        }
        return iterable;
    }

    @Override
    public void configurations(Closure closure) {
        this.getConfigurations().configure(closure);
    }

    @Override
    public void repositories(Closure closure) {
        ConfigureUtil.configure(closure, this.getRepositories());
    }

    @Override
    public void dependencies(Closure closure) {
        ConfigureUtil.configure(closure, this.getDependencies());
    }

    @Override
    public void artifacts(Closure closure) {
        ConfigureUtil.configure(closure, this.getArtifacts());
    }

    @Override
    public void buildscript(Closure closure) {
        ConfigureUtil.configure(closure, this.getBuildscript());
    }

    @Override
    public Task task(String string) {
        return this.taskContainer.add(string);
    }

    public Task task(Object object) {
        return this.taskContainer.add(object.toString());
    }

    @Override
    public Task task(String string, Closure closure) {
        return this.taskContainer.add(string).configure(closure);
    }

    public Task task(Object object, Closure closure) {
        return this.task(object.toString(), closure);
    }

    public Task task(Map map, String string) {
        return this.taskContainer.add(GUtil.addMaps(map, Collections.singletonMap("name", string)));
    }

    public Task task(Map map, Object object) {
        return this.task(map, object.toString());
    }

    public Task task(Map map, String string, Closure closure) {
        return this.taskContainer.add(GUtil.addMaps(map, Collections.singletonMap("name", string))).configure(closure);
    }

    public Task task(Map map, Object object, Closure closure) {
        return this.task(map, object.toString(), closure);
    }

    public Object passThrough(Object object) {
        return object;
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> clazz) {
        Instantiator instantiator = (Instantiator)this.getServices().get(Instantiator.class);
        return instantiator.newInstance(FactoryNamedDomainObjectContainer.class, clazz, instantiator, new DynamicPropertyNamer());
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> clazz, NamedDomainObjectFactory<T> namedDomainObjectFactory) {
        Instantiator instantiator = (Instantiator)this.getServices().get(Instantiator.class);
        return instantiator.newInstance(FactoryNamedDomainObjectContainer.class, clazz, instantiator, new DynamicPropertyNamer(), namedDomainObjectFactory);
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> clazz, Closure closure) {
        Instantiator instantiator = (Instantiator)this.getServices().get(Instantiator.class);
        return instantiator.newInstance(FactoryNamedDomainObjectContainer.class, clazz, instantiator, new DynamicPropertyNamer(), closure);
    }

    @Override
    public ExtensionContainer getExtensions() {
        return this.getConvention();
    }
}

