/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionsStorage {
    private final Map<String, Object> extensions = new LinkedHashMap<String, Object>();

    public void add(String string, Object object) {
        if (this.extensions.containsKey(string)) {
            throw new IllegalArgumentException(String.format("Cannot add extension with name '%s', as there is an extension already registered with that name.", string));
        }
        this.extensions.put(string, object);
    }

    public boolean hasExtension(String string) {
        return this.extensions.containsKey(string);
    }

    public Map<String, Object> getAsMap() {
        return this.extensions;
    }

    public void checkExtensionIsNotReassigned(String string) {
        if (this.hasExtension(string)) {
            throw new IllegalArgumentException(String.format("There's an extension registered with name '%s'. You should not reassign it via a property setter.", string));
        }
    }

    public boolean isConfigureExtensionMethod(String string, Object ... objectArray) {
        return this.extensions.containsKey(string) && objectArray.length == 1 && objectArray[0] instanceof Closure;
    }

    public Object configureExtension(String string, Object ... objectArray) {
        return ConfigureUtil.configure((Closure)objectArray[0], this.extensions.get(string));
    }

    public <T> T getByType(Class<T> clazz) {
        Collection<Object> collection = this.extensions.values();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Object object : collection) {
            Class<?> clazz2 = object.getClass();
            linkedList.add(clazz2.getSimpleName());
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return (T)object;
        }
        throw new UnknownDomainObjectException("Extension of type '" + clazz.getSimpleName() + "' does not exist. Currently registered extension types: " + linkedList);
    }

    public <T> T findByType(Class<T> clazz) {
        Collection<Object> collection = this.extensions.values();
        for (Object object : collection) {
            if (!clazz.isAssignableFrom(object.getClass())) continue;
            return (T)object;
        }
        return null;
    }

    public Object getByName(String string) {
        if (!this.hasExtension(string)) {
            throw new UnknownDomainObjectException("Extension with name '" + string + "' does not exist. Currently registered extension names: " + this.extensions.keySet());
        }
        return this.extensions.get(string);
    }

    public Object findByName(String string) {
        return this.extensions.get(string);
    }
}

