/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.plugins.DefaultPluginCollection;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.UnknownPluginException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectsPluginContainer
extends DefaultPluginCollection<Plugin>
implements PluginContainer {
    private PluginRegistry pluginRegistry;
    private final Project project;

    public DefaultProjectsPluginContainer(PluginRegistry pluginRegistry, Project project) {
        super(Plugin.class);
        this.pluginRegistry = pluginRegistry;
        this.project = project;
    }

    @Override
    public Plugin apply(String string) {
        return this.addPluginInternal(this.getTypeForId(string));
    }

    @Override
    public <T extends Plugin> T apply(Class<T> clazz) {
        return this.addPluginInternal(clazz);
    }

    @Override
    public boolean hasPlugin(String string) {
        return this.findPlugin(string) != null;
    }

    @Override
    public boolean hasPlugin(Class<? extends Plugin> clazz) {
        return this.findPlugin(clazz) != null;
    }

    @Override
    public Plugin findPlugin(String string) {
        try {
            return this.findPlugin(this.getTypeForId(string));
        }
        catch (UnknownPluginException unknownPluginException) {
            return null;
        }
    }

    @Override
    public <T extends Plugin> T findPlugin(Class<T> clazz) {
        for (Plugin plugin : this) {
            if (!plugin.getClass().equals(clazz)) continue;
            return (T)((Plugin)clazz.cast(plugin));
        }
        return null;
    }

    private <T extends Plugin> T addPluginInternal(Class<T> clazz) {
        if (this.findPlugin(clazz) == null) {
            Plugin<Project> plugin = this.providePlugin(clazz);
            this.add(plugin);
        }
        return (T)((Plugin)clazz.cast(this.findPlugin(clazz)));
    }

    @Override
    public Plugin getPlugin(String string) {
        Plugin plugin = this.findPlugin(string);
        if (plugin == null) {
            throw new UnknownPluginException("Plugin with id " + string + " has not been used.");
        }
        return plugin;
    }

    @Override
    public Plugin getAt(String string) throws UnknownPluginException {
        return this.getPlugin(string);
    }

    @Override
    public <T extends Plugin> T getAt(Class<T> clazz) throws UnknownPluginException {
        return this.getPlugin(clazz);
    }

    @Override
    public <T extends Plugin> T getPlugin(Class<T> clazz) throws UnknownPluginException {
        T t = this.findPlugin(clazz);
        if (t == null) {
            throw new UnknownPluginException("Plugin with type " + clazz + " has not been used.");
        }
        return (T)((Plugin)clazz.cast(t));
    }

    protected Class<? extends Plugin> getTypeForId(String string) {
        return this.pluginRegistry.getTypeForId(string);
    }

    private Plugin<Project> providePlugin(Class<? extends Plugin> clazz) {
        Plugin plugin = this.pluginRegistry.loadPlugin(clazz);
        plugin.apply(this.project);
        return plugin;
    }
}

