/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.PluginInstantiationException;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginRegistry
implements PluginRegistry {
    private final Map<String, Class<? extends Plugin>> idMappings = new HashMap<String, Class<? extends Plugin>>();
    private final DefaultPluginRegistry parent;
    private final ClassLoader classLoader;

    public DefaultPluginRegistry(ClassLoader classLoader) {
        this(null, classLoader);
    }

    private DefaultPluginRegistry(DefaultPluginRegistry defaultPluginRegistry, ClassLoader classLoader) {
        this.parent = defaultPluginRegistry;
        this.classLoader = classLoader;
    }

    @Override
    public PluginRegistry createChild(ClassLoader classLoader) {
        return new DefaultPluginRegistry(this, classLoader);
    }

    @Override
    public <T extends Plugin> T loadPlugin(Class<T> clazz) {
        if (this.parent != null) {
            return this.parent.loadPlugin(clazz);
        }
        if (!Plugin.class.isAssignableFrom(clazz)) {
            throw new InvalidUserDataException(String.format("Cannot create plugin of type '%s' as it does not implement the Plugin interface.", clazz.getSimpleName()));
        }
        try {
            return (T)((Plugin)clazz.newInstance());
        }
        catch (InstantiationException instantiationException) {
            throw new PluginInstantiationException(String.format("Could not create plugin of type '%s'.", clazz.getSimpleName()), instantiationException.getCause());
        }
        catch (Exception exception) {
            throw new PluginInstantiationException(String.format("Could not create plugin of type '%s'.", clazz.getSimpleName()), exception);
        }
    }

    @Override
    public Class<? extends Plugin> getTypeForId(String string) {
        Class<? extends Plugin> clazz;
        if (this.parent != null) {
            try {
                return this.parent.getTypeForId(string);
            }
            catch (UnknownPluginException unknownPluginException) {
                // empty catch block
            }
        }
        if ((clazz = this.idMappings.get(string)) != null) {
            return clazz;
        }
        URL uRL = this.classLoader.getResource(String.format("META-INF/gradle-plugins/%s.properties", string));
        if (uRL == null) {
            throw new UnknownPluginException("Plugin with id '" + string + "' not found.");
        }
        Properties properties = GUtil.loadProperties(uRL);
        String string2 = properties.getProperty("implementation-class");
        if (!GUtil.isTrue(string2)) {
            throw new PluginInstantiationException(String.format("No implementation class specified for plugin '%s' in %s.", string, uRL));
        }
        try {
            Class<?> clazz2 = this.classLoader.loadClass(string2);
            if (!Plugin.class.isAssignableFrom(clazz2)) {
                throw new PluginInstantiationException(String.format("Implementation class '%s' specified for plugin '%s' does not implement the Plugin interface. Specified in %s.", string2, string, uRL));
            }
            clazz = clazz2.asSubclass(Plugin.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PluginInstantiationException(String.format("Could not find implementation class '%s' for plugin '%s' specified in %s.", string2, string, uRL), classNotFoundException);
        }
        this.idMappings.put(string, clazz);
        return clazz;
    }
}

