/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.plugins.ObjectConfigurationAction;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.UriScriptSource;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectConfigurationAction
implements ObjectConfigurationAction {
    private final FileResolver resolver;
    private final ScriptPluginFactory configurerFactory;
    private final Set<Object> targets = new LinkedHashSet<Object>();
    private final Set<Runnable> actions = new LinkedHashSet<Runnable>();
    private final Object[] defaultTargets;

    public DefaultObjectConfigurationAction(FileResolver fileResolver, ScriptPluginFactory scriptPluginFactory, Object ... objectArray) {
        this.resolver = fileResolver;
        this.configurerFactory = scriptPluginFactory;
        this.defaultTargets = objectArray;
    }

    @Override
    public ObjectConfigurationAction to(Object ... objectArray) {
        GUtil.flatten(objectArray, this.targets);
        return this;
    }

    @Override
    public ObjectConfigurationAction from(final Object object) {
        this.actions.add(new Runnable(){

            public void run() {
                DefaultObjectConfigurationAction.this.applyScript(object);
            }
        });
        return this;
    }

    @Override
    public ObjectConfigurationAction plugin(final Class<? extends Plugin> clazz) {
        this.actions.add(new Runnable(){

            public void run() {
                DefaultObjectConfigurationAction.this.applyPlugin(clazz);
            }
        });
        return this;
    }

    @Override
    public ObjectConfigurationAction plugin(final String string) {
        this.actions.add(new Runnable(){

            public void run() {
                DefaultObjectConfigurationAction.this.applyPlugin(string);
            }
        });
        return this;
    }

    private void applyScript(Object object) {
        URI uRI = this.resolver.resolveUri(object);
        ScriptPlugin scriptPlugin = this.configurerFactory.create(new UriScriptSource("script", uRI));
        for (Object object2 : this.targets) {
            scriptPlugin.apply(object2);
        }
    }

    private void applyPlugin(Class<? extends Plugin> clazz) {
        for (Object object : this.targets) {
            if (object instanceof Project) {
                Project project = (Project)object;
                project.getPlugins().apply(clazz);
                continue;
            }
            throw new UnsupportedOperationException(String.format("Cannot apply plugin of class '%s' to '%s' (class: %s) as it is not a Project", clazz.getName(), object.toString(), object.getClass().getName()));
        }
    }

    private void applyPlugin(String string) {
        for (Object object : this.targets) {
            if (object instanceof Project) {
                Project project = (Project)object;
                project.getPlugins().apply(string);
                continue;
            }
            throw new UnsupportedOperationException(String.format("Cannot apply plugin with id '%s' to '%s' (class: %s) as it is not a Project", string, object.toString(), object.getClass().getName()));
        }
    }

    public void execute() {
        if (this.targets.isEmpty()) {
            this.to(this.defaultTargets);
        }
        for (Runnable runnable : this.actions) {
            runnable.run();
        }
    }
}

