/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.internal.BeanDynamicObject;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.Instantiator;
import org.gradle.api.internal.plugins.DefaultExtraPropertiesExtension;
import org.gradle.api.internal.plugins.ExtensionsStorage;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConvention
implements Convention {
    private final Map<String, Object> plugins = new LinkedHashMap<String, Object>();
    private final ExtensionsDynamicObject extensionsDynamicObject = new ExtensionsDynamicObject();
    private final ExtensionsStorage extensionsStorage = new ExtensionsStorage();
    private final ExtraPropertiesExtension extraProperties = new DefaultExtraPropertiesExtension();
    private final Instantiator instantiator;

    public DefaultConvention() {
        this(null);
    }

    public DefaultConvention(Instantiator instantiator) {
        this.instantiator = instantiator;
        this.add("ext", this.extraProperties);
    }

    @Override
    public Map<String, Object> getPlugins() {
        return this.plugins;
    }

    @Override
    public DynamicObject getExtensionsAsDynamicObject() {
        return this.extensionsDynamicObject;
    }

    private Instantiator getInstantiator() {
        if (this.instantiator == null) {
            throw new GradleException("request for DefaultConvention.instantiator when the object was constructed without a convention");
        }
        return this.instantiator;
    }

    @Override
    public <T> T getPlugin(Class<T> clazz) {
        T t = this.findPlugin(clazz);
        if (t == null) {
            throw new IllegalStateException(String.format("Could not find any convention object of type %s.", clazz.getSimpleName()));
        }
        return t;
    }

    @Override
    public <T> T findPlugin(Class<T> clazz) throws IllegalStateException {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Object object : this.plugins.values()) {
            if (!clazz.isInstance(object)) continue;
            arrayList.add(clazz.cast(object));
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() > 1) {
            throw new IllegalStateException(String.format("Found multiple convention objects of type %s.", clazz.getSimpleName()));
        }
        return (T)arrayList.get(0);
    }

    @Override
    public void add(String string, Object object) {
        if (object instanceof Class) {
            this.create(string, (Class)object, new Object[0]);
        } else {
            this.extensionsStorage.add(string, object);
        }
    }

    @Override
    public void add(String string, Class<?> clazz, Object ... objectArray) {
        DeprecationLogger.nagUserOfReplacedMethod("extensions.add(String, Class, Object...)", "extensions.create(String, Class, Object...)");
        this.create(string, clazz, objectArray);
    }

    @Override
    public <T> T create(String string, Class<T> clazz, Object ... objectArray) {
        T t = this.getInstantiator().newInstance(clazz, objectArray);
        this.add(string, t);
        return t;
    }

    @Override
    public ExtraPropertiesExtension getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public <T> T getByType(Class<T> clazz) {
        return this.extensionsStorage.getByType(clazz);
    }

    @Override
    public <T> T findByType(Class<T> clazz) {
        return this.extensionsStorage.findByType(clazz);
    }

    @Override
    public Object getByName(String string) {
        return this.extensionsStorage.getByName(string);
    }

    @Override
    public Object findByName(String string) {
        return this.extensionsStorage.findByName(string);
    }

    public Object propertyMissing(String string) {
        return this.getByName(string);
    }

    public void propertyMissing(String string, Object object) {
        this.extensionsStorage.checkExtensionIsNotReassigned(string);
        this.add(string, object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExtensionsDynamicObject
    implements DynamicObject {
        private ExtensionsDynamicObject() {
        }

        @Override
        public boolean hasProperty(String string) {
            if (DefaultConvention.this.extensionsStorage.hasExtension(string)) {
                return true;
            }
            for (Object v : DefaultConvention.this.plugins.values()) {
                if (!new BeanDynamicObject(v).hasProperty(string)) continue;
                return true;
            }
            return false;
        }

        public Map<String, Object> getProperties() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ArrayList arrayList = new ArrayList(DefaultConvention.this.plugins.values());
            Collections.reverse(arrayList);
            for (Object e : arrayList) {
                hashMap.putAll(new BeanDynamicObject(e).getProperties());
            }
            hashMap.putAll(DefaultConvention.this.extensionsStorage.getAsMap());
            return hashMap;
        }

        @Override
        public Object getProperty(String string) throws MissingPropertyException {
            if (DefaultConvention.this.extensionsStorage.hasExtension(string)) {
                return DefaultConvention.this.extensionsStorage.getByName(string);
            }
            for (Object v : DefaultConvention.this.plugins.values()) {
                BeanDynamicObject beanDynamicObject = new BeanDynamicObject(v);
                if (!beanDynamicObject.hasProperty(string)) continue;
                return beanDynamicObject.getProperty(string);
            }
            throw new MissingPropertyException(string, Convention.class);
        }

        public Object propertyMissing(String string) {
            return this.getProperty(string);
        }

        @Override
        public void setProperty(String string, Object object) {
            DefaultConvention.this.extensionsStorage.checkExtensionIsNotReassigned(string);
            for (Object v : DefaultConvention.this.plugins.values()) {
                BeanDynamicObject beanDynamicObject = new BeanDynamicObject(v);
                if (!beanDynamicObject.hasProperty(string)) continue;
                beanDynamicObject.setProperty(string, object);
                return;
            }
            throw new MissingPropertyException(string, Convention.class);
        }

        public void propertyMissing(String string, Object object) {
            this.setProperty(string, object);
        }

        @Override
        public Object invokeMethod(String string, Object ... objectArray) {
            if (DefaultConvention.this.extensionsStorage.isConfigureExtensionMethod(string, objectArray)) {
                return DefaultConvention.this.extensionsStorage.configureExtension(string, objectArray);
            }
            for (Object v : DefaultConvention.this.plugins.values()) {
                BeanDynamicObject beanDynamicObject = new BeanDynamicObject(v);
                if (!beanDynamicObject.hasMethod(string, objectArray)) continue;
                return beanDynamicObject.invokeMethod(string, objectArray);
            }
            throw new MissingMethodException(string, Convention.class, objectArray);
        }

        public Object methodMissing(String string, Object object) {
            return this.invokeMethod(string, (Object[])object);
        }

        @Override
        public boolean hasMethod(String string, Object ... objectArray) {
            if (DefaultConvention.this.extensionsStorage.isConfigureExtensionMethod(string, objectArray)) {
                return true;
            }
            for (Object v : DefaultConvention.this.plugins.values()) {
                BeanDynamicObject beanDynamicObject = new BeanDynamicObject(v);
                if (!beanDynamicObject.hasMethod(string, objectArray)) continue;
                return true;
            }
            return false;
        }
    }
}

