/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations.parsers;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.notations.api.NotationParser;
import org.gradle.api.internal.notations.api.UnsupportedNotationException;
import org.gradle.api.internal.notations.parsers.MapKey;
import org.gradle.api.internal.notations.parsers.TypedNotationParser;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.UncheckedException;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapNotationParser<T>
extends TypedNotationParser<Map, T>
implements NotationParser<T> {
    private final Method convertMethod = this.findConvertMethod();
    private final String[] keyNames = new String[this.convertMethod.getParameterAnnotations().length];
    private final boolean[] optional = new boolean[this.convertMethod.getParameterAnnotations().length];

    public MapNotationParser() {
        super(Map.class);
        for (int i = 0; i < this.convertMethod.getParameterAnnotations().length; ++i) {
            Annotation[] annotationArray = this.convertMethod.getParameterAnnotations()[i];
            this.keyNames[i] = this.keyName(annotationArray);
            this.optional[i] = this.optional(annotationArray);
        }
    }

    private Method findConvertMethod() {
        for (Method method : this.getClass().getDeclaredMethods()) {
            if (!method.getName().equals("parseMap")) continue;
            method.setAccessible(true);
            return method;
        }
        throw new UnsupportedOperationException(String.format("No parseMap() method found on class %s.", this.getClass().getSimpleName()));
    }

    @Override
    public void describe(Collection<String> collection) {
        collection.add("Maps");
    }

    @Override
    public T parseType(Map map) throws UnsupportedNotationException {
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
        TreeSet<String> treeSet = new TreeSet<String>();
        Object[] objectArray = new Object[this.convertMethod.getParameterTypes().length];
        for (int i = 0; i < objectArray.length; ++i) {
            String string = this.keyNames[i];
            boolean bl = this.optional[i];
            Class<?> clazz = this.convertMethod.getParameterTypes()[i];
            String string2 = clazz.equals(String.class) ? this.get(hashMap, string) : clazz.cast(hashMap.get(string));
            if (!bl && string2 == null) {
                treeSet.add(string);
            }
            hashMap.remove(string);
            objectArray[i] = string2;
        }
        if (!treeSet.isEmpty()) {
            throw new InvalidUserDataException(String.format("Required keys %s are missing from map %s.", treeSet, map));
        }
        try {
            object = this.convertMethod.invoke((Object)this, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw UncheckedException.throwAsUncheckedException((Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw UncheckedException.unwrapAndRethrow((InvocationTargetException)invocationTargetException);
        }
        ConfigureUtil.configureByMap(hashMap, object);
        return (T)object;
    }

    private boolean optional(Annotation[] annotationArray) {
        for (Annotation annotation : annotationArray) {
            if (!(annotation instanceof Optional)) continue;
            return true;
        }
        return false;
    }

    private String keyName(Annotation[] annotationArray) {
        for (Annotation annotation : annotationArray) {
            if (!(annotation instanceof MapKey)) continue;
            return ((MapKey)annotation).value();
        }
        throw new UnsupportedOperationException("No @Key annotation on parameter of parseMap() method");
    }

    protected String get(Map<String, Object> map, String string) {
        String string2;
        Object object = map.get(string);
        String string3 = string2 = object != null ? object.toString() : null;
        if (string2 != null && string2.length() == 0) {
            return null;
        }
        return string2;
    }
}

