/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations.parsers;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.notations.api.NotationParser;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatteningNotationParser<T>
implements NotationParser<Set<T>> {
    private final NotationParser<T> delegate;

    public FlatteningNotationParser(NotationParser<T> notationParser) {
        assert (notationParser != null) : "delegate cannot be null";
        this.delegate = notationParser;
    }

    @Override
    public void describe(Collection<String> collection) {
        this.delegate.describe(collection);
        collection.add("Collections or arrays of any other supported format. Nested collections/arrays will be flattened.");
    }

    @Override
    public Set<T> parseNotation(Object object) {
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>();
        Collection collection = GUtil.collectionize(object);
        for (Object e : collection) {
            linkedHashSet.add(this.delegate.parseNotation(e));
        }
        return linkedHashSet;
    }
}

