/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations.parsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.notations.api.NotationParser;
import org.gradle.api.internal.notations.api.UnsupportedNotationException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorHandlingNotationParser<T>
implements NotationParser<T> {
    private final String targetTypeDisplayName;
    private final String invalidNotationMessage;
    private final NotationParser<T> delegate;

    public ErrorHandlingNotationParser(String string, String string2, NotationParser<T> notationParser) {
        this.targetTypeDisplayName = string;
        this.invalidNotationMessage = string2;
        this.delegate = notationParser;
    }

    @Override
    public void describe(Collection<String> collection) {
        this.delegate.describe(collection);
    }

    @Override
    public T parseNotation(Object object) {
        try {
            return this.delegate.parseNotation(object);
        }
        catch (UnsupportedNotationException unsupportedNotationException) {
            Object object2 = unsupportedNotationException.getNotation();
            Formatter formatter = new Formatter();
            if (object2 == null) {
                formatter.format("Cannot convert a null value to an object of type %s.%n", this.targetTypeDisplayName);
            } else {
                formatter.format("Cannot convert the provided notation to an object of type %s: %s.%n", this.targetTypeDisplayName, object2);
            }
            formatter.format("The following types/formats are supported:", new Object[0]);
            ArrayList<String> arrayList = new ArrayList<String>();
            this.describe(arrayList);
            for (String string : arrayList) {
                formatter.format("%n  - %s", string);
            }
            if (GUtil.isTrue(this.invalidNotationMessage)) {
                formatter.format("%n%s", this.invalidNotationMessage);
            }
            throw new InvalidUserDataException(formatter.toString());
        }
    }
}

